const mix = require('laravel-mix');

mix.setPublicPath('public/assets/');

mix.config.fileLoaderDirs.images = 'images';
mix.config.fileLoaderDirs.fonts = 'fonts';

mix.options({
    cleanCss: {
        level: {
            1: {
                specialComments: 'none'
            }
        }
    },

    postCss: [
        require('postcss-discard-comments')({removeAll: true})
    ],

    // purifyCss: true
});

mix.styles([
    'resources/assets/css/fullpage.css',
    'resources/assets/css/style.css',
    'resources/assets/css/font/stylesheet.css',
    'resources/assets/css/fancybox.css',
    'resources/assets/css/noty.css',
    'resources/assets/css/custom.css',
], 'public/assets/css/app.css');


mix.babel(
    [
        'resources/assets/js/jquery.min.js',
        'resources/assets/js/fullpage.js',
        'resources/assets/js/nette.js',
        'resources/assets/js/fancybox.js',
        'resources/assets/js/slick.min.js',
        'resources/assets/js/sticky.js',
        'resources/assets/js/parallax.min.js',
        'resources/assets/js/noty.js',
        'resources/assets/js/noty.settings.js',
        'resources/assets/js/social-share-kit.js',
    ],
    'public/assets/js/app.js'
);

mix.copyDirectory('resources/assets/images', 'public/assets/images')
    .copy('resources/assets/favicon.png', 'public/favicon.png');

mix.copyDirectory('resources/assets/css/font', 'public/assets/font');


if (mix.config.inProduction) {
    mix.webpackConfig({
        plugins: [
            new CopyWebpackPlugin([{
                from: 'resources/assets/images',
                to: 'assets/images',
            }]),
            new ImageminPlugin({
                test: /\.(jpe?g|png|gif|svg)$/i,
                plugins: [
                    imageminMozjpeg({
                        quality: 70,
                    })
                ]
            })
        ]
    });
}
