<?php
namespace Nette\Upload;

use Illuminate\Support\ServiceProvider;

class NetteUploadServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;
    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__.'/../../config/config.php' => config_path('upload.php'),
        ], 'nette-upload-config');


        $this->publishes([
            __DIR__.'/../../config/image-optimizer.php' => config_path('image-optimizer.php'),
        ], 'nette-image-optimizer-config');

        $this->publishes([
            __DIR__.'/../../../assets' => public_path('assets/vendor/admin/js'),
        ], 'nette-upload-public');

        $this->loadMigrationsFrom(__DIR__.'/../../migrations');

        $this->loadRoutesFrom(__DIR__.'/routes.php');
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $packageConfigFile = __DIR__.'/../../config/config.php';
        $this->mergeConfigFrom($packageConfigFile, 'upload');

        $this->app->singleton('UploadManager',function($app){
            return new \Nette\Upload\Libraries\UploadManager();
        });

    }
}
