<?php

namespace Nette\Multilingual\Traits;

use \Mcamara\LaravelLocalization\LaravelLocalization;

trait MultiLingualModel
{

    private function localizedAttributeName($field,$locale) {
        return $field . '_'. $locale;
    }

    public function __get($key){
        if (config('nette-lang.enable')) {
            $attributeNameExist = in_array($key,$this->multiLingualFillable);
            if($attributeNameExist){
                $name = $this->{$this->localizedAttributeName($key, _clang())};
                return strlen($name) ? $name : '';
            }
        }
        return parent::__get($key);
    }

    public static function findByMultiSlug($slug){
        $currentLang = _clang();
        $item = self::where("slug_{$currentLang}",$slug)->first();
        if($item){
            return $item;
        } else {
            abort(404);
        }

        return false;
    }

    public function scopeMultislug($query,$slug){
        $currentLang = _clang();
        return $query->where("slug_{$currentLang}",$slug);
    }

    public function getFillable()
    {
        if (config('nette-lang.enable')) {
            $fillableList = [];
            foreach (_getSupportedLanguagesAsArray() as $key => $lang) {
                foreach (($this->multiLingualFillable ?? []) as $fieldKey) {
                    array_push($fillableList, "{$fieldKey}_{$key}");
                }
            }
        } else {
            $fillableList = ($this->multiLingualFillable ?? []);
        }
        return array_merge($this->fillable,$fillableList);
    }

    public function sluggable() : array {
        $return = [];
        if (config('nette-lang.enable')) {
            foreach (LaravelLocalization::getSupportedLocales() as $key => $lang) {
                $field = $this->multiLingualSlugField;
                $return['slug_' . $key] = [
                    'source' => $field . '_' . $key,
                    'includeTrashed' => true,
                    'onUpdate' => true
                ];
            }
            return $return;
        } else {
            $field = $this->slugField;
            return [
                'slug' => [
                    'source' => $field,
                    'includeTrashed' => true,
                    'onUpdate' => true
                ]
            ];
        }
    }


}
