<?php
namespace Nette\Multilingual;

use Illuminate\Support\ServiceProvider;
class NetteMultilingualServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;
    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__.'/../../config/config.php' => config_path('nette-lang.php'),
        ], 'nette-multilingual-config');

        $this->loadViewsFrom(__DIR__.'/../../views', 'Multilingual');


    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $packageConfigFile = __DIR__.'/../../config/config.php';
        $this->mergeConfigFrom($packageConfigFile, 'nette-lang');

    }
}
