<?php
namespace Nette\Multilingual\Database\Schema;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Schema\Builder;
use LaravelLocalization;

/**
 * #### For Multilingual Systems Multingual field Creation Plugin ####
 * @package App\Libraries
 */
class ExtendedBlueprint extends Blueprint
{

    /**
     * Create string field with name as formatted $fieldname_$langkey for each supported language keys
     *
     *
     * @param      $column
     * @param      $nullable
     * @param null $length
     * @throws \Mcamara\LaravelLocalization\Facades\SupportedLocalesNotDefined
     */
    public function multiLangString($column, $nullable, $length = null)
    {
        if (config('nette-lang.enable')) {
            foreach (LaravelLocalization::getSupportedLocales() as $key => $lang) {
                $this->multiLangStringField($column, $key, $nullable);
            }
        } else {
            $this->singleLangStringField($column, $nullable, $length);
        }
    }

    /**
     * Create string field with name as formatted $fieldname_$langkey for a single language
     *
     * @param      $column
     * @param      $lang
     * @param      $nullable
     * @param null $length
     * @return \Illuminate\Support\Fluent
     */
    public function multiLangStringField($column, $lang, $nullable, $length = null)
    {

        $length = $length ?: Builder::$defaultStringLength;
        $col = $this->string($this->columnKey($column,$lang), compact($length));
        if ($nullable) $col = $col->nullable();

        return $col;
    }

    /**
     * Create string field with name as formatted $fieldname for a single language
     *
     * @param      $column
     * @param      $nullable
     * @param null $length
     * @return \Illuminate\Support\Fluent
     */
    public function singleLangStringField($column, $nullable, $length = null)
    {
        $length = $length ?: Builder::$defaultStringLength;
        $col = $this->string($column, compact($length));
        if ($nullable) $col = $col->nullable();

        return $col;
    }

    /**
     * Create text field with name as formatted $fieldname_$langkey for each supported language keys
     *
     *
     * @param $column
     * @param $nullable
     * @throws \Mcamara\LaravelLocalization\Facades\SupportedLocalesNotDefined
     */
    public function multiLangText($column, $nullable)
    {
        if (config('nette-lang.enable')) {
            foreach (LaravelLocalization::getSupportedLocales() as $key => $lang) {
                $this->multiLangTextField($column, $key, $nullable);
            }
        } else {
            $this->singleLangTextField($column, $nullable);
        }
    }

    /**
     * Create text field with name as formatted $fieldname_$langkey for a single language
     *
     * @param $column
     * @param $lang
     * @param $nullable
     * @return \Illuminate\Support\Fluent
     */
    public function multiLangTextField($column, $lang, $nullable)
    {
        $col = $this->text($this->columnKey($column,$lang));
        if ($nullable) $col = $col->nullable();

        return $col;
    }

    /**
     * Create text field with name as formatted $fieldname for a single language
     *
     * @param $column
     * @param $nullable
     * @return \Illuminate\Support\Fluent
     */
    public function singleLangTextField($column, $nullable)
    {
        $col = $this->text($column);
        if ($nullable) $col = $col->nullable();

        return $col;
    }


    /**
     * Drops Multilingual Column  for each supported language keys
     *
     * @param $column
     */
    public function dropMultiLingualColumn($column)
    {

        if (config('nette-lang.enable')) {
            foreach (LaravelLocalization::getSupportedLocales() as $key => $lang) {
                $this->dropColumn($this->columnKey($column,$key));
            }
        } else {
            $this->dropColumn($column);
        }

    }


    /**
     * Returns Formatted Column Key
     *
     * @param $column
     * @param $lang
     * @return string
     */
    private function columnKey($column, $lang) {

        return $column . '_' . $lang;
    }

}