<?php

namespace Nette\Multilingual\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Nette\Admin\Models\Admin;
use Carbon\Carbon;
use File;

class MultilingualFileEditorController extends Controller
{

    /**
     * Render Language editor
     *
     * $fileName here means main lang file for first open
     *
     * @param string $fileName
     * @return mixed
     */
    public function index($fileName = 'auth')
    {

        $defaultLang = config('app.locale');

        $files = File::allFiles(resource_path('lang' . DIRECTORY_SEPARATOR . $defaultLang));

        $file = resource_path('lang' . DIRECTORY_SEPARATOR . $defaultLang . DIRECTORY_SEPARATOR . $fileName . '.php');


        if (!File::exists($file)) {
            return abort(404);
        }

        $fileContents = require($file);

        $fileContents = array_dot($fileContents);

        // Source'u config icine at.

//        return $fileContents;
        return view('Multilingual::setting')
            ->with('files', $files)
            ->with('fileContents', $fileContents)
            ->with('fileName', $fileName);

    }

    /**
     * Update & Generate lang files with data from index page
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request)
    {

        $input = $request->all();

        // Recursive arrayler için çözüm, iyileştirilmesi lazım.
        function arrayProcess($key, $value, $zey)
        {

            $row = '';
            if (is_array($value)) {

                $row = "\t'$key' => [\n";
                foreach ($value as $bol => $balue) {
                    $row .= arrayProcess($bol, $balue, $zey);
                }
                $row .= "\t],\n";

            } else {
                if ($key == $zey and $value != '') {
                    $row .= "{'" . trim(_e($value)) . "'}";
                }
            }
            $row = str_replace("[\n{'", "'", $row);
            $row = str_replace("'}\t]", "'", $row);
            $row = str_replace("[\n\t]", "''", $row);


            return $row;
        }

        foreach (config('laravellocalization.supportedLocales') as $zey => $zield) {

            // Dil dosyamizin baslangic tagleri.
            $fileContent = "<?php\n\nreturn [\n\n";

            foreach ($input as $key => $value) {
                $fileContent .= arrayProcess($key, $value, $zey);
            }

            $fileName = $input['fileName'];

            // Klasör var mi? Yoksa olusturalim.
            $isFolderExist = File::exists(resource_path(DIRECTORY_SEPARATOR . 'lang' . DIRECTORY_SEPARATOR . $zey));

            if (!$isFolderExist) {
                File::makeDirectory(resource_path(DIRECTORY_SEPARATOR . 'lang' . DIRECTORY_SEPARATOR . $zey));
            }

            // Dosya var mi?
            $isFileExist = File::exists(resource_path('lang' . DIRECTORY_SEPARATOR . $zey . DIRECTORY_SEPARATOR . $fileName . '.php'));

            // Altina, olusturulma tarihini not duselim.
            if (!$isFileExist) {
                $fileContent .= "\t// file_created_at: ||" . Carbon::now() . "||\n\n];";
            } else {
                $fileContent .= "\t// file_updated_at: ||" . Carbon::now() . "||\n\n];";
            }

            // Boş olan değerleri uçuruyoruz. / app.locale değilse tabi.
            if ($zey != config('app.locale')) {
                $fileContent = preg_replace('/\t\'(.*?)\' => \'\',\n/', '', $fileContent);
            }

            // Dosyayı kaydediyoruz, yoksa olusturuyoruz.
            File::put(resource_path('lang' . DIRECTORY_SEPARATOR . $zey . DIRECTORY_SEPARATOR . $fileName . '.php'), $fileContent);

        }

        $request->session()->flash('success', 'Dil dosyası başarıyla güncellendi!');
        return redirect()->route('admin.multilingual.index', $fileName);

    }

}
