@extends('admin::_layouts.content',['selectedMenu'=>$cMenuKey])

@section('content')
    <div class="page-header">
        <div class="page-header-content header-elements-md-inline">
            <div class="page-title d-flex">
                <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold"> {{ $cTitle }}</span> -
                    {{ $cShowTitle }}</h4>
                <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
            </div>
        </div>
    </div>
    <div class="content pt-0 ">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header header-elements-inline">
                        <h5 class="card-title">
                            İçerik
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-2"><h6><strong>Konu</strong>
                                    <strong style="float:right;">:</strong></h6></div>
                            <div class="col-10">
                                {{ $item->subject }}
                            </div>
                            <div class="col-2"><h6><strong>Mesaj</strong>
                                    <strong style="float:right;">:</strong></h6></div>
                            <div class="col-10">
                                {{ $item->body }}
                            </div>
                            <div class="col-2"><h6><strong>İsim</strong>
                                    <strong style="float:right;">:</strong></h6></div>
                            <div class="col-10">
                                {{ $item->name }}
                            </div>
                            <div class="col-2"><h6><strong>Telefon</strong>
                                    <strong style="float:right;">:</strong></h6></div>
                            <div class="col-10">
                                {{ $item->phone }}
                            </div>
                            <div class="col-2"><h6><strong>E-Mail</strong>
                                    <strong style="float:right;">:</strong></h6></div>
                            <div class="col-10">
                                {{ $item->email }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4">
                <div class="card">
                    <div class="card-header header-elements-inline">
                        <h5 class="card-title">
                            Gönderim Bilgisi
                        </h5>
                    </div>
                    <div class="card-body">
                        {{--<div class="alert alert-danger" role="alert">--}}
                        {{--<strong>Dikkat!</strong>--}}
                        {{--<p>--}}
                        {{--Bu alandaki değişkenler kod tarafından çağırılan değişkenlerdir.<br>--}}
                        {{--Ne yaptığınızı bilmiyorsanız bu alanları değiştirmeyin.--}}
                        {{--</p>--}}
                        {{--</div>--}}
                        <div class="row">
                            <div class="col-4"><h6><strong>Tarih
                                        <strong style="float:right;">:</strong>
                                    </strong></h6></div>
                            <div class="col-8">
                                {{ $item->created_at->diffForHumans() }} - {{ $item->created_at->format('d/m/Y H:i') }}
                            </div>
                            <div class="col-4"><h6><strong>IP Adresi</strong>
                                    <strong style="float:right;">:</strong></h6></div>
                            <div class="col-8">
                                {{ $item->ip }}
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="f-save-bar">
            <div class="buttons">
                {!! backbtn(url()->previous()) !!}
            </div>
        </div>
    </div>


@endsection

