<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateContactsTable extends Migration
{
    public function up()
    {
        Schema::create('contacts', function ($table) {
            $table->engine = 'InnoDB';

            $table->increments('id');
            $table->string('subject',150);
            $table->text('body')->nullable();
            $table->string('name', 150)->nullable();
            $table->string('phone', 150)->nullable();
            $table->string('email', 150)->nullable();
            $table->boolean('read')->default(false);
            $table->ipAddress('ip');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::drop('contacts');
    }
}
