<?php

namespace Nette\Contact\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Mail;

class Contact extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'body',
        'name',
        'email',
        'phone',
        'subject',
        'ip',
        'read'
    ];

    public static $rules = [
        'name' => 'required|max:150',
        'body' => 'required',
        'email' => 'required|email',
//        'g-recaptcha-response' => 'required|captcha'
    ];

    public static $attr = [
        'name' => 'Ad Soyad',
        'body' => 'Mesaj',
        'subject' => 'Konu',
        'email' => 'Email',
//        'g-recaptcha-response' => 'Güvenlik kodu'
    ];

    protected static function boot()
    {
        parent::boot();

        static::created(function ($model) {

            if (_config('contact_notify') && _config('contact_notify_targets')) {

                $target['replyto'] = $model->email;
                $target['replytoname'] = $model->name;

                $target['others'] = explode(',', _config('contact_notify_targets'));
                $target['others'] = array_map('trim', $target['others']);

                Mail::send('contact::notifications.contact', ['model' => $model], function ($message) use ($target) {
                    $message->to($target['others'])
                        ->replyTo($target['replyto'], $target['replytoname'])
                        ->subject('Yeni İletişim Mesajı');
                });

            }

            if (_config('contact_send_reply')) {

                $thanks['send'] = $model->email;

                Mail::send('contact::notifications.thanks', ['model' => $model], function ($message) use ($thanks) {
                    $message->to($thanks['send'])
                        ->subject(config('nette-lang.enable') ? trans('contact.email_template.thanks') : 'Mesajınız Alındı');
                });
            }


        });

    }
}
