<?php

namespace Nette\Contact\Controllers;

use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController;
use Nette\Admin\Models\Admin;
use Nette\Contact\Models\Contact;
use FilterGenerator;

class ContactController extends AdminBaseController
{
    public $cTitle = 'İletişim';
    public $cIndexTitle = 'İletişim Mesajları';

    public $cMenuKey = 'contact';

    public $cBreadcrumb = [
        'name' => 'İletişim Mesajları',
        'route' => 'admin.contact.index',
    ];

    public $cModel = Contact::class;
    public $cModelName = 'İletişim Mesajı';

    public $cKey = 'contact';

    public $cBladeKey = null;

    public $cShow = true;
    public $cShowRoute = 'admin.contact.show';
    public $cShowTitle = 'Görüntüle';
    public $cShowBlade = 'contact::show';
    public $cShowPermission = 'contact.view';

    public $cEdit = false;

    public $cDelete = true;
    public $cDeleteRoute = 'admin.contact.destroy';

    public $cBatchDelete = true;
    public $cBatchDeleteRoute = 'admin.contact.batchdestroy';

    public $cOrderable = false;

    public $cFields = [
        'id' => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name' => ['name' => 'İsim', 'sortable' => true,],
        'email' => ['name' => 'E-Posta', 'sortable' => true, 'size' => 'medium'],
        'read' => ['name' => 'Okundu', 'size' => 'mini'],
        'created_at' => ['name' => 'Tarih', 'size' => 'medium'],
    ];

    public $cMultiLangFields = [
//        'name' => 'İsim',
    ];

    public $cFieldMutators = [
        'read' => 'isRead',
        'created_at' => 'timeFormat'
    ];

    public $relations = [
        'admin_id' => Admin::class
    ];

    public $cFilterable = true;

    public $filters = [
        'field' => [
            'name' => 'Gönderen Adı',
            'type' => 'text',
            'operator' => 'like'
        ],
    ];

    public function __construct()
    {
        parent::__construct();

    }

    public function index()
    {

        $this->check('cIndexPermission');
        $column = request()->get('order_field', 'created_at');
        $direction = request()->get('order_dir', 'desc');

        $items = $this->cModel::orderBy('read','ASC')->orderBy($column, $direction);
        if ($this->cFilterable) {
            $items = FilterGenerator::apply($this->filters, $items);
        }

        $items = $items->paginate(_config('admin.rows', 500));

        return view($this->blade('index'))
            ->with('items', $items);

    }

    public function show($id)
    {
        $this->check('cShowPermission');
        if (!$id) {
            abort(404);
        }

        $item = $this->cModel::findOrFail($id);

        $item->read = true;
        $item->save();

        return view($this->blade('show'))
            ->with('item', $item);
    }

}
