@extends('admin::_layouts.content',['selectedMenu'=>'admins'])

@section('title')
    {!! ($item??false) ? 'Düzenle' : 'Yeni' !!}
@endsection

@section('content')
    @include('admin::_partials.tinymce')
    <div class="page-header">
        <div class="page-header-content header-elements-md-inline">
            <div class="page-title d-flex">
                <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">Sayfa</span> - {!! ($item??false) ? 'Düzenle' : 'Yeni' !!}</h4>
                <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
            </div>
        </div>
    </div>
    <div class="content pt-0 ">
        {!! html()->model($item ?? [])->form($method,$methodURL)->open() !!}
        {!! skey() !!}
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header header-elements-inline">
                        <h5 class="card-title">Sayfa Bilgileri</h5>
                        <div class="header-elements">
                            <div class="list-icons">
                                <a class="list-icons-item" data-action="collapse"></a>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">

                        @if(config('nette-lang.enable'))
                            <div class="tabbable">
                                <ul class="nav nav-tabs nav-justified">
                                    @foreach (\LaravelLocalization::getSupportedLocales() as $key => $lang)
                                        <li class="nav-item">
                                            <a aria-controls="lang_{{$key}}" aria-selected="true" class="nav-link @if($key == LaravelLocalization::getCurrentLocale()) active @endif" data-toggle="tab" href="#lang_{{$key}}" id="lang-{{$key}}-tab" role="tab">{{ $lang['native'] }}</a>
                                        </li>
                                    @endforeach
                                </ul>

                                <div class="tab-content">
                                    @foreach (\LaravelLocalization::getSupportedLocales() as $key => $lang)

                                        <div class="tab-pane{!! ($key=='tr') ? ' active': null !!}" id="lang_{{$key}}">
                                            <div class="f-group">
                                                {!! html()->label('Sayfa Başlığı ('.$lang['native'].')')->for('name') !!}
                                                {!! html()->text('name_'.$key)->placeholder('Sayfa Başlığı ('.$lang['native'].')')->addClass('form-control'); !!}
                                            </div>

                                            <div class="f-group">
                                                {!! html()->label('İçerik ('. $lang['native'] .')')->for('content') !!}
                                                {!! html()->textarea('content_'.$key)->placeholder('İçerik ('. $lang['native'] .')')->addClass('form-control')->data('editor','true') !!}
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @else
                            <div class="f-group">
                                {!! html()->label('Sayfa Başlığı')->for('name') !!}
                                {!! html()->text('name')->placeholder('Sayfa Başlığı')->addClass('form-control'); !!}
                            </div>
                            <div class="f-group">
                                {!! html()->label('İçerik')->for('content') !!}
                                {!! html()->textarea('content')->placeholder('İçerik')->addClass('form-control')->data('editor','true') !!}
                            </div>
                        @endif
                    </div>
                </div>

                @include('admin::_partials.meta')

                {!!
                   uploader(
                       'img',
                       'page_gallery',
                       'Sayfa Galerisi',
                       'page_gallery',
                       'images',
                        null,
                        true,
                        (isset($item) ? $item->images : null),
                        (isset($item) ? route($cOrderMediaRoute, ['id'=>$item->id]) : null),
                        (isset($item) ? route($cUpdateMediaRoute,['id'=>$item->id]) : null),
                        (isset($item) ? route($cDeleteMediaRoute,['id'=>$item->id]) : null)
                       )
                   !!}

            </div>
            @include('admin::_partials.sidebar._sidebar')
        </div>
        <div class="f-save-bar">
            <div class="buttons">
                {!! backbtn(url()->previous()) !!}
                {!! savebtn() !!}
            </div>
        </div>
        {!! html()->form()->close() !!}
    </div>
@endsection

