@extends('admin::_layouts.content',['selectedMenu'=>'log'])


@section('content')
    <div class="page-header">
        <div class="page-header-content header-elements-md-inline">
            <div class="page-title d-flex">
                <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold"> Kayıtlar</span> - Liste </h4>
            </div>
        </div>
    </div>
    <div class="content pt-0 ">
        <div class="card">
            <table class="table log-table">
                <thead></thead>
                <tbody></tbody>
            </table>
        </div>
        <!-- /basic datatable -->

    </div>


@endsection

@section('foot')

    <script type="text/javascript">
        var LogDataTable = function() {
            var _component = function() {
                if (!$().DataTable) {
                    console.warn('Warning - datatables.min.js is not loaded.');
                    return;
                }

                // Setting datatable defaults
                $.extend( $.fn.dataTable.defaults, {
                    autoWidth: false,
                    columnDefs: [{
                        orderable: false,
                        width: 100,

                    }],
                    dom: '<"datatable-header"fl><"datatable-scroll"t><"datatable-footer"ip>',
                    language: {
                        search: '<span>Arama:</span> _INPUT_',
                        searchPlaceholder: 'Filtrelemek için',
                        lengthMenu: '<span>Göster:</span> _MENU_',
                        paginate: {
                            'first': 'İlk',
                            'son': 'Son',
                            'sonraki': $('html').attr('dir') == 'rtl' ? '&larr;' : '&rarr;',
                            'önceki': $('html').attr('dir') == 'rtl' ? '&rarr;' : '&larr;'
                        },
                        emptyTable:     "Veri Mevcut Değil",
                        info:           "Toplam _TOTAL_ kayıt arasından _START_ ile _END_ arası gösteriliyor.",
                        infoEmpty:      "Toplam 0 kayıt arasından 0 ile 0 arası gösteriliyor.",
                        infoFiltered:   "(Toplam _MAX_ kayıt arasından filtrelendi)",
                        zeroRecords:    "Uyuşan Kayıt bulunamadı",
                        processing:     "İşleniyor...",
                    }
                });

            };
            return {
                init: function() {
                    _component();

                }
            }
        }();
        document.addEventListener('DOMContentLoaded', function() {
            LogDataTable.init();

            $('.log-table').dataTable({
                'processing': true,
                'serverSide': true,
                "pageLength": 50,
                'ajax': {
                    'url': '{!! route('admin.log.data') !!}'
                },
                'columns': [
                    {data: 'id', title: 'ID', width: 75},
                    {data: 'name', title: 'İsim'},
                    {data: 'description', title: 'İşlem', width: 100},
                    {data: 'ip', title: 'IP', width: 150},
                    {data: 'created_at', title: 'Tarih', width: 250},
                ],
                'order': [[0,'desc']]
            });
        });
    </script>

@endsection

