@extends('admin::_layouts.content',['selectedMenu'=>$cMenuKey])

@section('content')
    <div class="page-header">
        <div class="page-header-content header-elements-md-inline">
            <div class="page-title d-flex">
                <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold"> {{ $cTitle }}</span> -
                    {{ $cShowTitle }}</h4>
                <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
            </div>
        </div>
    </div>
    <div class="content pt-0 ">
        <div class="card">
            <div class="card-body">
                @foreach(($cFields ?? []) as $fieldKey => $fieldData)
                    @if((!isset($fieldData['permission'])) || (isset($fieldData['permission']) && checkPermission($fieldData['permission'])))
                        @if(config('nette-lang.enable') && ($fieldData['multilang'] ?? false))
                            @foreach(_getSupportedLanguagesAsArray() as $langKey => $lang)

                                <div class="row">
                                    <div class="col-4"><h6><strong>{{$fieldData['name'] . '('.$lang.')' }}</strong></h6></div>
                                    <div class="col-8">
                                        {{ $item->{localizedAttributeName($fieldKey,$langKey)} }}
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <div class="row">
                                <div class="col-4"><h6><strong>{{$fieldData['name']}}</strong></h6></div>
                                <div class="col-8">

                                    @if(isset($cFieldMutators[$fieldKey]))
                                        {!! $cFieldMutators[$fieldKey](($item->$fieldKey) ?? '') !!}
                                    @else
                                        {{($item->$fieldKey) ?? ''}}
                                    @endif

                                </div>
                            </div>
                        @endif
                    @endif

                @endforeach
            </div>


        </div>

        <div class="f-save-bar">
            <div class="buttons">
                {!! backbtn(url()->previous()) !!}
            </div>
        </div>
    </div>


@endsection

