@extends('admin::_layouts.empty')


@section('content')
    <div class="content d-flex justify-content-center align-items-center">
        <form method="POST" action="{!! route('admin.login.post') !!}" accept-charset="UTF-8" role="form" id="loginform" class="login-form form-validate">
            @csrf
            <div class="card mb-0">
                <div class="card-body">
                    <div class="text-center mb-3">
                        <img class="rounded-circle" src="{!!
                        (config('admin.login_logo',null)) ?
                        asset(config('admin.login_logo')) :
                        asset('vendor/admin/images/logo_admin.png')
                        !!}" alt="{{config('app.name')}}">

                        <h5 class="mb-0 mt-2">Giriş Yapın</h5>
                        <span class="d-block text-muted">Giriş Bilgileri</span>
                    </div>

                    <div class="f-group @if($errors->has('email')) error @endif">
                        <div class="f-group-feedback ">
                            {!! html()->text('email')->placeholder('E-Posta')->addClass('form-control')->value(old('email')); !!}
                            @if ($errors->has('email'))
                            <div class="icon">
                                <i class="icon-cancel-circle2"></i>
                            </div>
                            @endif
                        </div>
                        @if ($errors->has('email'))<span>{{ $errors->first('email') }}</span>@endif
                    </div>

                    <div class="f-group @if($errors->has('password')) error @endif">
                        <div class="f-group-feedback ">
                            {!! html()->password('password')->placeholder('Şifre')->addClass('form-control')->value(''); !!}
                            @if ($errors->has('password'))
                                <div class="icon">
                                    <i class="icon-cancel-circle2"></i>
                                </div>
                            @endif
                        </div>
                        @if ($errors->has('password'))<span>{{ $errors->first('password') }}</span>@endif
                    </div>

                    <div class="f-group">
                        {!! html()-> submit('Giriş')->class('btn btn-primary')->value(html()->i('')->class('icon-circle-right2 ml-2')) !!}
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection


