@extends('admin::_layouts.content',['selectedMenu'=>'admins'])

@section('title')
    {!! ($item??false) ? 'Düzenle' : 'Yeni' !!}
@endsection

@section('content')
    <div class="page-header">
        <div class="page-header-content header-elements-md-inline">
            <div class="page-title d-flex">
                <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">Yönetici</span> -
                    {!! ($item??false) ? 'Düzenle' : 'Ekle' !!}</h4>
                <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
            </div>
        </div>
    </div>
    <div class="content pt-0 ">
        {!! html()->model($item ?? [])->form($method,$methodURL)->open() !!}
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header header-elements-inline">
                        <h5 class="card-title">Yönetici Bilgileri</h5>
                        <div class="header-elements">
                            <div class="list-icons">
                                <a class="list-icons-item" data-action="collapse"></a>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <div class="f-group">
                            {!! html()->label('Kullanıcı Adı')->for('name') !!}
                            {!! html()->text('name')->placeholder('İsim')->addClass('form-control'); !!}
                        </div>
                        <div class="f-group">
                            {!! html()->label('E-Posta')->for('email') !!}
                            {!! html()->text('email')->placeholder('E-Posta')->addClass('form-control'); !!}
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="f-group password">
                                    {!! html()->label('Şifre')->for('password') !!}
                                    <div class="withbadge">
                                        {!! html()->password('password')->placeholder('Şifre')->addClass('form-control')->value(''); ; !!}
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="f-group">
                                    {!! html()->label('Şifre Tekrar')->for('password_confirmation') !!}
                                    <div class="withbadge">
                                        {!! html()->password('password_confirmation')->placeholder('Şifre Tekrar')->addClass('form-control')->value(''); !!}
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="f-group">
                                    <div class="f-bs-switch">
                                        <label class="">
                                            {!!
                                                    html()
                                                    ->checkbox('status',(isset($item) ? $item->status : 1),1)
                                                    ->class('bs-switch')
                                                    ->data('on-text','AKTİF')
                                                    ->data('off-text','PASİF')
                                                    ->data('on-color','success')
                                                    ->data('off-color','danger')
                                             !!}
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col">
                <div class="card">
                    <div class="card-header header-elements-inline">
                        <h5 class="card-title">Grup & Yetkilendirme</h5>
                        <div class="header-elements">
                            <div class="list-icons">
                                <a class="list-icons-item" data-action="collapse"></a>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        @if(admin()->isSuperUser())
                            <legend class="f-legend">Superuser</legend>
                            <div class="f-group">
                                <div class="alert alert-danger" role="alert">
                                    <strong>Dikkat!</strong>
                                    <p>
                                        Bir kullancıyı "Superuser" olarak yetkilendirmek o kullanıcıya sistemdeki her modülü yönetme hakkı, tüm kayıtlara erişim ve düzenleme yetkisi sağlar. Superuser kullanıcılar sisteme direkt olarak etki edebilir ve sistemde her türlü değişikliği yapabilir.
                                    </p>
                                </div>
                                <div class="f-bs-switch">
                                    <label class="">
                                        {!!
                                                html()
                                                ->checkbox('superuser',(isset($item) && $item->isSuperUser())?true:null,'true')
                                                ->class('bs-switch')
                                                ->data('on-text','EVET')
                                                ->data('off-text','HAYIR')
                                                ->data('on-color','danger')
                                                ->data('off-color','default')
                                         !!}
                                        Superuser
                                    </label>
                                </div>
                            </div>
                        @endif

                        <legend class="f-legend">Gruplar</legend>
                        <div class="f-group">

                            @foreach($groups as $group)
                                <div class="form-check">
                                    <label class="form-check-label">
                                        {!! html()->checkbox('groups['.$group["id"].']',(isset($group['checked'])?$group['checked']:null),$group["id"])->class('form-check-input-styled-primary') !!}
                                        {!! $group["name"] !!}
                                    </label>
                                </div>
                            @endforeach

                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="f-save-bar">
            <div class="buttons">
                {!! backbtn(url()->previous()) !!}
                {!! savebtn() !!}
            </div>
        </div>
        {!! html()->form()->close() !!}
    </div>
@endsection

