@extends('admin::_layouts.content',['selectedMenu'=>'admingroups'])

@section('content')

    <div class="page-header">
        <div class="page-header-content header-elements-md-inline">
            <div class="page-title d-flex">
                <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">Yönetici Grupları</span> - Liste</h4>
                <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
            </div>

            <div class="header-elements d-none text-center text-md-left mb-3 mb-md-0">
                {!! createbtn('admin.admingroups.create') !!}
            </div>
        </div>
    </div>
    <div class="content pt-0 ">
        <div class="card">
            <div class="card-header header-elements-inline">
                <h5 class="card-title">Liste</h5>

            </div>
            <div class="index-table">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th>İsim</th>
                            <th class="table-column-medium">Yönetici Sayısı</th>
                            <th class="table-column-actions">İşlemler</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($items as $item)
                            <tr>
                                <td>{{ $item->name }}</td>
                                <td>{{ $item->Admins->count()}}</td>
                                <td class="table-column-actions">
                                    {!! editbtn('admin.admingroups.edit',['id'=>$item->id]) !!}
                                    {!! deletebtn('admin.admingroups.destroy',['id'=>$item->id]) !!}
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="table-bottom">
                    <div class="table-batch-actions">
                        <div class="wrap"></div>
                    </div>
                    <div class="table-pagination">
                        {!! pagination($items) !!}
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

