@extends('admin::_layouts.content',['selectedMenu'=>'admins'])

@section('content')

    <div class="page-header">
        <div class="page-header-content header-elements-md-inline">
            <div class="page-title d-flex">
                <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">Yönetici Grupları</span> - {!! ($item??false) ? 'Düzenle' : 'Yeni' !!}</h4>
                <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
            </div>
        </div>
    </div>
    <div class="content pt-0 ">
        {!! html()->model($item ?? [])->form($method,$methodURL)->open() !!}
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header header-elements-inline">
                        <h5 class="card-title">Yönetici Grubu Bilgileri</h5>
                        <div class="header-elements">
                            <div class="list-icons">
                                <a class="list-icons-item" data-action="collapse"></a>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <div class="f-group">
                            {!! html()->label('Grup Adı')->for('name')->class('f-label') !!}
                            {!! html()->text('name')->placeholder('Grup Adı')->addClass('form-control'); !!}
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header header-elements-inline">
                        <h5 class="card-title">İzinler</h5>
                        <div class="header-elements">
                            <div class="list-icons">
                                <a class="list-icons-item" data-action="collapse"></a>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">

                        @foreach($modules as $moduleKey => $module)
                            @if(count($module['permissions'] ?? []) >0)
                                <div class="parent">
                                    <legend class="f-legend-big">
                                        {{ $module['info']['name'] }}
                                        {!! html()->checkbox($moduleKey.'All',false,1)->class('f-switchery-all') !!}
                                    </legend>
                                    <div class="row childrencontainer">
                                        @foreach(($module['permissions'] ?? []) as $modulePermissionKey => $modulePermission)

                                            <div class="col-12 col-lg-4 col-xl-3">
                                                <div class="f-switchery">
                                                    <label class="">
                                                        {!! html()->checkbox($modulePermissionKey,($permissionGrid[$modulePermissionKey] ?? false),1)->class('f-switchery-input') !!}

                                                        <div class="d-block ml-1">
                                                            <div class="font-weight-semibold"> {{ $modulePermission }}</div>
                                                            <span class="text-muted">{{ $modulePermissionKey }}</span>
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        @endforeach


                    </div>
                </div>
            </div>
        </div>
        <div class="f-save-bar">
            <div class="buttons">
                {!! backbtn(url()->previous()) !!}
                {!! savebtn() !!}
            </div>
        </div>
        {!! html()->form()->close() !!}
    </div>

@endsection

