<script src="{{ asset('vendor/admin/tinymce/tinymce.min.js') }}"></script>
<script type="text/javascript">

    tinymce.PluginManager.add('relatedcontent', function (editor, url) {
        var openSelectionModal = function (editor) {
            window.openRelatedSelectionModal(editor);
        };

        editor.addButton('relatedcontent', {
            text: 'İçerik',
            onclick: function () {
                // Open window
                openSelectionModal(editor);
            }
        });

        return {
            getMetadata: function () {
                return {
                    name: "Related Content",
                    url: "https://nette.com.tr"
                };
            }
        };
    });


    tinymce.PluginManager.add("quickupload", function (editor, url) {

        var inp = $('<input id="tinymce-quickuploader" type="file" name="pic" accept="image/*" style="display:none">');
        $(editor.getElement()).parent().append(inp);

        function _uploadFile(inp, editor) {
            var input = inp.get(0);
            var data = new FormData();
            data.append('quickupload', input.files[0]);
            data.append('type', 'Images');
            data.append('working_dir', '/{!! admin()->id !!}');
            data.append('_token', '{!! csrf_token() !!}');

            $.ajax({
                url: '/laravel-filemanager/quickupload',
                type: 'POST',
                data: data,
                processData: false, // Don't process the files
                contentType: false, // Set content type to false as jQuery will tell the server its a query string request
                success: function(data, textStatus, jqXHR) {
                    if(data.url !== undefined) {
                        editor.insertContent('<img src="' + data.url + '"/>');
                    } else {
                        new Noty({
                            text: data,
                            type: 'error',
                            timeout: 5000
                        }).show();
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    if(jqXHR.responseText) {
                        errors = JSON.parse(jqXHR.responseText).errors;
                        new Noty({
                            text:  errors.join(", "),
                            type: 'error',
                            timeout: 5000
                        }).show();
                    }
                }
            });
        }

        function _onAction() {
            inp.trigger('click');
        }

        inp.on("change", function (e) {
            _uploadFile($(this), editor);
        });

        // Define the Toolbar button
        editor.addButton('quickupload', {
            icon: "upload",
            tooltip: "Hızlı Yükleme",
            onclick: _onAction
        });

        // Define the Menu Item
        editor.addMenuItem('quickupload', {
            text: 'Q',
            context: 'insert',
            onclick: _onAction
        });

        return {
            getMetadata: function () {
                return {
                    name: "Nette TinyMCE quickuploader",
                    url: "https://nette.com.tr"
                };
            }
        };
    });

</script>
<style>
    .mce-branding {
        display: none
    }
</style>
<script>
    (function ($) {
        'use strict';
        $(document).ready(function () {

            var tinyPlugins = [
                "visualblocks",
                "preview",
                "code",
                "fullscreen",
                "wordcount",
                "code",
                "charmap",
                "colorpicker",
                "hr",
                "lists",
                "media",
                "paste",
                "tabfocus",
                "textcolor",
                "fullscreen",
                "link",
                "image",
                "wordcount",
                "quickupload"
            ];

            if ($('#related-container').length > 0) {
                tinyPlugins.push("relatedcontent")
            }

            tinyMCE.init({
                selector: "textarea[data-editor='true']",
                height: 400,
                theme: "modern",
                skin: "lightgray",
                branding: false,
                formats: {
                    alignleft: [
                        {selector: 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles: {textAlign: 'left'}},
                        {selector: 'img,table', classes: 'alignleft'}
                    ],
                    aligncenter: [
                        {selector: 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles: {textAlign: 'center'}},
                        {selector: 'img,table', classes: 'aligncenter'}
                    ],
                    alignright: [
                        {selector: 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles: {textAlign: 'right'}},
                        {selector: 'img,table', classes: 'alignright'}
                    ],
                    strikethrough: {inline: 'del'}
                },
                // TinyMCE'ye tüm HTML öğelerini kabul etmesini söyle
                valid_elements: '*[*]',
                extended_valid_elements: '*[*]',
                force_p_newlines: false,
                force_br_newlines: true,
                convert_newlines_to_brs: false,
                remove_linebreaks: true,
                forced_root_block: false,
                remove_script_host: false,
                convert_urls: false,
                browser_spellcheck: true,
                fix_list_elements: true,
                entities: "38,amp,60,lt,62,gt",
                entity_encoding: "raw",
                keep_styles: false,
                preview_styles: "font-family font-size font-weight font-style text-decoration text-transform",
                end_container_on_empty_block: true,
                plugins: [
                    "visualblocks",
                    "preview",
                    "code",
                    "fullscreen",
                    "wordcount",
                    "code",
                    "charmap",
                    "colorpicker",
                    "hr",
                    "lists",
                    "media",
                    "paste",
                    "tabfocus",
                    "textcolor",
                    "fullscreen",
                    "link",
                    "image",
                    "wordcount",
                    "quickupload"
                    // Eğer related-container varsa relatedcontent plugini ekle
                    ,"relatedcontent"
                ],
                resize: true,
                menubar: false,
                indent: false,
                toolbar1: "formatselect fontselect fontsizeselect | bold italic underline strikethrough | forecolor backcolor | bullist numlist blockquote, | hr ",
                toolbar2: "undo redo | alignleft aligncenter alignright alignjustify | pastetext removeformat charmap | outdent indent | link unlink | quickupload image media relatedcontent | visualblocks fullscreen | code preview ",
                language: "tr_TR",
                path_absolute: "/",
                relative_urls: false,
                file_browser_callback: function (field_name, url, type, win) {
                    // File browser callback kodu burada olacak
                }
            });
            ;
        });
    })(jQuery);
</script>
