<div aria-hidden="true" aria-labelledby="filterModel" class="modal fade filter-box" role="dialog" tabindex="-1">
    <div class="modal-dialog modal-{!! (count($allFilters)>5)?'lg':'md' !!}">
        <form id="filterForm" action="{!! FilterGenerator::getFilterBaseUrl() !!}" method="get">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">
                        Filtrele
                    </h5>
                    <button aria-label="Close" class="close" data-dismiss="modal" type="button"><span aria-hidden="true"> &times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        @foreach(collect($allFilters)->chunk(5) as $chunk)
                            <div class="col">
                                @foreach($chunk as $filterKey => $filter)
                                    @include('admin::_partials.filters._elements.'.($filter['type']??'text'),
                                            [
                                                'filterKey' =>$filterKey,
                                                'filter'=>$filter,
                                                'activeFilters'=>$activeFilters,
                                                'allFilters'=>$allFilters
                                            ])
                                @endforeach
                            </div>
                        @endforeach
                    </div>


                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-dismiss="modal" type="button"> Kapat</button>
                    <button class="btn btn-primary" type="submit" value="true" name="apply_filter">Filtrele</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="filter-list" style="margin: 20px;">
    @foreach($activeFilters as $activeFilterKey => $activeFilter)
        <div class="filter-item" style="display: inline-block;margin: 5px 10px;font-weight: bold;">
            {!! $allFilters[$activeFilterKey]['name'] !!}
            <span class="ml-2 badge badge-light">
                {!! FilterGenerator::getFilterPresentation($allFilters,$activeFilter,$activeFilterKey) !!}

            </span>
            <a href="{!! FilterGenerator::removeFilterItem($activeFilterKey) !!}" class="badge badge-danger badge-icon filter-close">
                <i class="icon-cross"></i>
            </a>
        </div>
    @endforeach
</div>





