@extends('admin::_layouts.main')

@section('maintitle')
    @if(isset($cTitle))
        {{ $cTitle }}
    @else
        @hasSection('title')
            @yield('title') - {{config('app.name')}}
        @endif
    @endif
@endsection

@section('mainhead')
    @yield('head')

    @if(count($cCSSModules ?? []))
        @foreach($cCSSModules as $cssModule)
            @include($cssModule)
        @endforeach
    @endif

@endsection

@section('mainbodyclass')
    @yield('bodyclass')
@endsection


@section('maincontent')
    @include('admin::_partials.navbar')
    @if(config('admin.horizontal_menu',false))
        {!! ModuleLoader::generateMenu($selectedMenu ?? false , true) !!}
    @endif
    <div class="page-content">
        @if(!config('admin.horizontal_menu',false))
            {!! ModuleLoader::generateMenu($selectedMenu ?? false,false) !!}
        @endif
        <div class="content-wrapper">
            @yield('content')
        </div>
    </div>
@endsection


@section('mainfoot')
    @yield('foot')

    @if(count($cJSModules ?? []))
        @foreach($cJSModules as $jsModule)
            @include($jsModule)
        @endforeach
    @endif
@endsection
