<?php

namespace Nette\Admin\Seeds;

use Illuminate\Database\Seeder;

use Nette\Admin\Models\Admin;
use Nette\Admin\Models\AdminGroup;
use Nette\Admin\Models\Page;

class RandomPages extends Seeder
{
    public function run()
    {
        $faker = \Faker\Factory::create("tr_TR");

        for ($i = 0; $i <= 100; $i++) {
            if (config('nette-lang.enable')) {
                $dat = [];
                foreach (_getSupportedLanguageKeysAsArray() as $langKey) {
                    $dat['name_' . $langKey] = $faker->words(5, true);
                    $dat['content_' . $langKey] = $faker->text(1000);
                }
                Page::create($dat);
            } else {
                Page::create([
                    'name' => $faker->words(5, true),
                    'content' => $faker->text(1000),
                ]);
            }
        }

    }
}
