<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdminPackage extends Migration
{
    public function up()
    {
        Schema::create('admins', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name');
            $table->string('email')->unique();
            $table->string('password');

            $table->text('permissions')->nullable();

            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('admin_groups', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->string('name');
            $table->text('permissions')->nullable();
            $table->timestamps();
        });


        //Admin <-> Groups Pivot Table
        Schema::create('admins_admin_groups', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->integer('admin_id')->unsigned()->index();
            $table->foreign('admin_id')->references("id")->on('admins')->onDelete('cascade');

            $table->integer('group_id')->unsigned()->index();
            $table->foreign('group_id')->references("id")->on('admin_groups')->onDelete('cascade');

            $table->timestamps();
        });


    }

    public function down()
    {
        Schema::dropIfExists('admins_admin_groups');
        Schema::dropIfExists('admin_groups');
        Schema::dropIfExists('admins');
    }
}
