<?php

Route::group(['prefix' => config('admin.prefix'), 'as' => 'admin.','middleware'=>['web']], function () {

    Route::get('login',         ['as' => 'login.get', 'uses' => 'Nette\Admin\Controllers\AuthController@showLoginForm']);
    Route::post('login',        ['as' => 'login.post', 'uses' => 'Nette\Admin\Controllers\AuthController@login']);

    Route::group(['middleware' => [Nette\Admin\Middlewares\RedirectIfNotAdmin::class]], function () {
        Route::get('logout',    ['as' => 'logout', 'uses' => 'Nette\Admin\Controllers\AuthController@logout']);
        Route::get('/',         ['as' => 'index', 'uses' => 'Nette\Admin\Controllers\IndexController@index']);
    });

    Route::group(['prefix' => 'analytics','as' => 'analytics.'], function () {
        Route::post('/visitors', ['as' => 'visitors', 'uses' => 'Nette\Admin\Controllers\AnalyticsController@userTypes']);
        Route::post('/data', ['as' => 'data', 'uses' => 'Nette\Admin\Controllers\AnalyticsController@analyticsData']);
        Route::post('/referrals', ['as' => 'referrals', 'uses' => 'Nette\Admin\Controllers\AnalyticsController@referralData']);
        Route::post('/location', ['as' => 'location', 'uses' => 'Nette\Admin\Controllers\AnalyticsController@geoVisitors']);
        Route::post('/keywords', ['as' => 'keywords', 'uses' => 'Nette\Admin\Controllers\AnalyticsController@searchKeyword']);
        Route::post('/social', ['as' => 'social', 'uses' => 'Nette\Admin\Controllers\AnalyticsController@socialMedia']);
    });


});