<?php

function admin($force_recheck = false)
{
    /*
     *      METOD: admin
     *
     *      Giriş yapmış kullanıcıyı döner. static keywordu ile onu ilk kullanımda saklar ve script bitene kadar tutar
     *      İkinci bir kez veritabanından ya da Sessiondan çekmez.
     *
     *      Zorla kontrol edilmesi ve yenilenmesi gerekiyorsa force_recheck true verilerek yenilenmesi sağlanır.
     *
     *      Giriş yapılmadığında false döner.
     *
     */

    if (!Auth::guard('admin')->check())
        return false;

    static $admin = null;

    if (is_null($admin) || $force_recheck) {

        $admin = Auth::guard('admin')->user();
        $admin->permits = $admin->Permissions();
        if (!$admin) {
            $admin = new Nette\Admin\Models\Admin;
        }
    }

    return $admin;
}

function _config($key, $default = null)
{
    return config('set.' . $key, $default);
}

function pagination($collection)
{
    return $collection->appends(array_except($_GET, 'page'))->links('admin::_partials.pagination');
}

function checkPermission()
{

    $params = func_get_args() ?? [];
    $user = admin();
    $permission = array_shift($params);

    if ($user) {
        //isSuperUser ?
        if ($user->isSuperUser()) return true;
        // merged group and user permission
        $permissions = $user->permits;


        //dd($permissions);

        if (isset($permissions[$permission]) and $permissions[$permission] == 1) {
            return true;
        }
    }

    return false;
}

function _sorting($column)
{

    $class = 'icon-sort';

    $request = request();
    $urlParameters = $request->all();

    //Get Base Url
    $baseUrl = $request->url();

    //Get Active Order Commands
    $order_direction = $request->get('order_dir', null);
    $order_field = $request->get('order_field', null);

    //Target direction
    $target_direction = '';

    if ($order_field == $column) {
        if ($order_direction == 'asc') {
            $target_direction = 'desc';
            $class = 'icon-sort-alpha-asc';
        } else {
            $target_direction = 'asc';
            $class = 'icon-sort-alpha-desc ';
        }
    } else {
        $target_direction = 'asc';
    }

    $urlParameters['order_field'] = $column;
    $urlParameters['order_dir'] = $target_direction;

    //Build Url

    $queryString = '';
    foreach ($urlParameters as $key => $value) {
        if ($value != '') {
            if (is_array($value)) {
                foreach ($value as $k => $v) {
                    $queryString .= '&' . $key . urlencode('[') . $k . urlencode(']') . '=' . $v;
                }
            } else {
                $queryString .= '&' . $key . '=' . $value;
            }
        }
    }

    $resultUrl = trim($baseUrl . '?' . trim($queryString, '&'), '?');
    $result = html()->a($resultUrl, html()->i()->class($class));
    return $result;
}

if (!function_exists('result')) {
    function result($result, $action = null)
    {
        return (object)['result' => (bool)$result, 'action' => $action];
    }
}

if (!function_exists('getFillable')) {
    function getFillable($model = null, $key = null)
    {
        if (!is_null($model)) {
            $model = new $model;
            $fillable = $model->getFillable();
            $fillable = array_flip($fillable);

            if (isset($fillable[$key])) {
                return true;
            }
        }

        return false;
    }
}

if (!function_exists('isLocked')) {
    function isLocked($isLocked)
    {
        if ($isLocked == 1) {
            $icon = '<i class="icon-checkmark position-center icon-red" data-popup="tooltip" title="Evet" data-placement="right"></i>';
        } else {
            $icon = '<i class="icon-cross2 position-center icon-green" data-popup="tooltip" title="Hayır" data-placement="right"></i>';
        }

        return $icon;
    }
}

if (!function_exists('createbtn')) {
    function createbtn($routeName, $params = [])
    {
        return html()
            ->a(route($routeName, $params), 'Yeni' . html()->element('b')->child(html()->i('')->class('icon-plus3')))
            ->class('create-btn');
    }
}

if (!function_exists('editbtn')) {
    function editbtn($routeName, $params = [])
    {
        return html()
            ->a(route($routeName, $params), html()->i()->class('icon-pencil5'))
            ->class('edit-btn');
    }
}

if (!function_exists('deletebtn')) {
    function deletebtn($routeName, $params = [])
    {
        return html()
            ->a('#', html()->i()->class('icon-bin'))
            ->data('target', route($routeName, $params))
            ->class('delete-btn');
    }
}

if (!function_exists('showbtn')) {
    function showbtn($routeName, $params = [])
    {
        return html()
            ->a(route($routeName, $params), html()->i()->class('icon-eye'))
            ->class('show-btn');
    }
}

if (!function_exists('publishbtn')) {
    function publishbtn($routeName, $params = [], $status = false)
    {
        return html()
            ->a('#', html()->i()->addClass($status ? 'icon-checkmark4' : 'icon-cross2'))
            ->data('target', route($routeName, $params))
            ->class('publish-btn')->addClass($status ? 'published' : 'unpublished');
    }
}

if (!function_exists('savebtn')) {
    function savebtn()
    {
        return html()
            ->button('Kaydet' . html()->i('')->class('icon-floppy-disk')->addClass('ml-2'))
            ->type('submit')
            ->class('btn')->addClass('bg-blue')->addClass('ml-3')->addClass('legitRipple');

    }
}

if (!function_exists('backbtn')) {
    function backbtn($url)
    {
        return html()
            ->a($url ?? '#', html()->i('')->class('icon-arrow-left16')->addClass('mr-2') . 'Geri')
            ->class('btn')->addClass('btn-light')->addClass('legitRipple');


    }
}

if (!function_exists('batchorderbtn')) {
    function batchorderbtn()
    {
        return html()
            ->button(html()->i('')->class('icon-floppy-disk')->addClass('mr-2') . 'Sıralamayı Kaydet')
            ->type('submit')
            ->class('btn')->addClass('batch-save-item');

    }
}

if (!function_exists('batchdeletebtn')) {
    function batchdeletebtn($routeName)
    {
        return html()
            ->a('#', html()->i()->class('icon-bin'))
            ->data('target', route($routeName))
            ->class('btn')->addClass('batch-delete-item');

    }
}

if (!function_exists('adminlangs')) {
    function adminlangs()
    {
        $langList = config('admin.admin_panel_langs', [config('app.locale')]);
        $ret = [];
        foreach (Arr::only(\LaravelLocalization::getSupportedLocales(), $langList) as $key => $locale) {
            $ret[$key] = $locale['name'];
        }
        return $ret;

    }
}


if (!function_exists('seoTitle')) {
    function seoTitle($meta = null, $currentTitle = null)
    {
        if (is_array($meta)) {
            if (config('nette-lang.enable')) {
                if (isset($meta[_clang()]['title']) && !empty($meta[_clang()]['title']))
                    return $meta[_clang()]['title'];

            } else {
                if (isset($meta['title']) && !empty($meta['title']))
                    return $meta['title'];
            }

        }
        return $currentTitle . ' - ' . _config("site_name");
    }
}

if (!function_exists('seoDescription')) {
    function seoDescription($meta = null, $currentDescription = null)
    {
        if (is_array($meta)) {
            if (config('nette-lang.enable')) {
                if (config('nette-lang.enable')) {
                    if (isset($meta['description_' . _clang()]) && !empty($meta['description' . _clang()])) {
                        return $meta['description_' . _clang()];
                    } elseif (!empty($currentDescription)) {
                        return Str::limit(strip_tags($currentDescription), 155);
                    }
                }
            } else {
                if (isset($meta['description']) && !empty($meta['description'])) {
                    return $meta['description'];
                } elseif (!empty($currentDescription)) {
                    return Str::limit(strip_tags($currentDescription), 155);
                }
            }
        }

        return _config('site_description', '');
    }
}

if (!function_exists('seoKeywords')) {
    function seoKeywords($meta = null, $default = null)
    {
        if (is_array($meta)) {
            if (config('nette-lang.enable')) {
                if (isset($meta['keywords_' . clang()]) && !empty($meta['keywords' . _clang()])) {
                    return $meta['keywords_' . _clang()];
                } elseif (!empty($default)) {
                    return Str::limit(strip_tags($default), 300);
                }
            } else {
                if (isset($meta['keywords']) && !empty($meta['keywords'])) {
                    return $meta['keywords'];
                } elseif (!empty($default)) {
                    return Str::limit(strip_tags($default), 300);
                }
            }
        }

        return _config('site_description', '');
    }
}

//blade icerisinde static sayfalara erismek maksadiyla olusturuldu
if (!function_exists('getPageWithKey')) {
    function getPageWithKey($key)
    {
        $pageModel = new PageData();
        return $pageModel->getPageWithKey($key);
    }
}


if (!function_exists('getAdmin')) {
    function getAdmin($id)
    {
        $admin = \Nette\Admin\Models\Admin::withTrashed()->find($id);
        return $admin ? $admin->name : 'Tanımsız';
    }
}

if (!function_exists('frontUrl')) {
    function frontUrl($object)
    {
        if ($object) {
            return html()->a(
                $object['url'],
                $object['name'])->attribute('target', 'blank');
        }
        return '';
    }
}


if (!function_exists('globalDate')) {
    function globalDate($date)
    {
        return $date->format('d-m-Y H:i');
    }
}