<?php

namespace Nette\Admin\Traits;

use Mcamara\LaravelLocalization\LaravelLocalization;

trait SlugTrait
{

    public function autoSluggable()
    {
        if (config('nette-lang.enable')) {
            $return = [];
            foreach (self::$multiLingualSlug ?? [] as $source => $target) {
                foreach (_getSupportedLanguagesAsArray() as $key => $lang) {
                    $return[$target . '_' . $key] = [
                        'source' => $source . '_' . $key,
                        'includeTrashed' => true,
                        'onUpdate' => true
                    ];
                }
            }


            return $return;

        } else {
            $return = [];
            foreach (self::$slug ?? [config('admin.auto_slug_field') => 'slug'] as $source => $target) {
                $return[$target] = [
                    'source' => $source,
                    'includeTrashed' => true,
                    'onUpdate' => true
                ];
            }
            return $return;
        }
    }

}
