<?php

namespace Nette\Admin\Traits;
use Arr;
trait RequestUtils
{

    public function all($keys = null)
    {

        if (!isset(static::$relatedModel)) {
            throw new \Error('This Request not connected to any model');
        }
        $input = parent::all($keys);
        if (isset(self::$relatedModel::$checks)) {
            foreach (self::$relatedModel::$checks as $inputKey) {

                if (!in_array($inputKey, array_keys($input))) {

                    //Bu Bir checkbox ve boş olduğu için gelmemiş
                    $input[$inputKey] = 0;
                }
            }
        }

        if (isset(self::$relatedModel::$zeros)) {
            if (isset(self::$relatedModel::$zeros)) {
                foreach (self::$relatedModel::$zeros as $inputKey) {
                    if (array_key_exists($inputKey, $input) && $input[$inputKey] == null) {
                        //Bu Bir alan ve null olduğu için sıfıra eitlenecek
                        $input[$inputKey] = 0;
                    }
                }
            }
        }

        //created_at & updated_at alanları null ise bunları request içerisinden çıkartıyoruz.
        if(array_key_exists('created_at',$input) && $input['created_at'] == null){
            unset($input['created_at']);
        }

        if(array_key_exists('updated_at',$input) && $input['updated_at'] == null){
            unset($input['updated_at']);
        }


        return $input;
    }

    public function authorize()
    {
        return true;
    }

    public function rules()
    {

        if(config('nette-lang.enable')) {
            $multiLingualRules = self::multiLingualRules() ?? [];
            return array_merge(Arr::except(self::$relatedModel::$rules,array_keys(self::$relatedModel::$multiLingualRules ?? [])), $multiLingualRules);
        }

        return self::$relatedModel::$rules;
    }

    public function multiLingualRules() {
        $multiLingualRules = [];
        $ruleData = self::$relatedModel::$multiLingualRules ?? [];
        foreach ($ruleData as $ruleKey => $rule) {
            $langs = _getSupportedLanguagesAsArray();
            foreach ($langs as $langKey => $langName) {
                $multiLingualRules[$ruleKey . '_' . $langKey] = $rule;
            }
        }

        return $multiLingualRules ?? [];
    }

    public function attributes()
    {
        if(config('nette-lang.enable')) {
            $multiLingualAttributes = self::multiLingualAttributes() ?? [];
            return array_merge(Arr::except(self::$relatedModel::$attr,array_keys(self::$relatedModel::$multiLingualAttr ?? [])), $multiLingualAttributes);
        }
        return self::$relatedModel::$attr;
    }

    public function multiLingualAttributes() {
        $multiLingualAttributes = [];
        $attrData = self::$relatedModel::$multiLingualAttr ?? [];
        foreach ($attrData as $attrKey => $attr) {
            $langs = _getSupportedLanguagesAsArray();
            foreach ($langs as $langKey => $langName) {
                $multiLingualAttributes[$attrKey . '_' . $langKey] = ($attrData[$attrKey]) ? $attr . ' (' . $langName . ')' : $attrKey . '_' . $langKey;
            }
        }

        return $multiLingualAttributes;
    }

}
