<?php
namespace Nette\Admin;

use Illuminate\Support\ServiceProvider;
use ModuleLoader;
use File;
use Illuminate\Support\Facades\Blade;
use Config;
use Illuminate\Support\Facades\Gate;
use Nette\Admin\Console\SyncPackageDb;


class NetteAdminServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;
    /**
     * Bootstrap the application events.
     *
     * @return void
     */

    protected $policies = [];

    public function boot()
    {

        $this->registerPolicies();


        $this->publishes([
            __DIR__.'/../../config/config.php' => config_path('admin.php'),
            __DIR__.'/../../config/settings.php' => config_path('settings.php'),
            __DIR__.'/../../config/activitylog.php' => config_path('activitylog.php'),
            __DIR__.'/../../config/lfm.php' => config_path('lfm.php'),
            __DIR__.'/../../config/analytics.php' => config_path('analytics.php'),
        ], 'nette-admin-config');

        $this->loadMigrationsFrom(__DIR__.'/../../migrations');

        $this->loadRoutesFrom(__DIR__.'/routes.php');

        $this->loadViewsFrom(__DIR__.'/../../views', 'admin');

        $this->publishes([
            __DIR__.'/../../views' => resource_path('views/vendor/admin'),
        ],'nette-admin-view');

        $this->publishes([
            __DIR__.'/../../../assets' => public_path('assets/vendor/admin'),
        ], 'nette-admin-public');

        Blade::directive('selectmenu', function ($expression) {
            return '<?php $selectedMenu = '.$expression.'; ?>';
        });

        Blade::directive('check', function($expression)
        {
            return "<?php if(checkPermission($expression)): ?>";
        });

        Blade::directive('endcheck', function($expression)
        {
            return '<?php endif; ?>';
        });

        Blade::directive('layoutmodule', function($expression)
        {
            $text = '';
            $text .= '<?php if(isset($cLayoutModules)): ?>';
            $text .= '<?php if(count($cLayoutModules['.$expression.'] ?? [])): ?>';
            $iteratee = '$cLayoutModules['.$expression.'] ?? []';
            $iteration = '$layoutModule';

            $initLoop = "\$__currentLoopData = {$iteratee}; \$__env->addLoop(\$__currentLoopData);";
            $iterateLoop = '$__env->incrementLoopIndices(); $loop = $__env->getLastLoop();';


            $text .= "<?php {$initLoop} foreach(\$__currentLoopData as {$iteration}): ?>";

            $text .= "<?php echo \$__env->make($iteration, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>";

            $text .= '<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>';

            $text .= '<?php endif; ?>';
            $text .= '<?php endif; ?>';


            return $text;

        });


        ModuleLoader::load();
        $this->loadSettings();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {

        $this->mergeConfigFrom(__DIR__.'/../../config/config.php', 'admin');

        //Following Line Disabled because laravel doesnt allow multidimentional Array Merge from mergeConfigFrom
        //Dont Know why
        //$this->mergeConfigFrom(__DIR__.'/../../config/auth.php', 'auth');

        $this->commands([
            SyncPackageDb::class
        ]);


        $this->app->singleton('ModuleLoader',function($app){
            return new \Nette\Admin\ModuleLoader();
        });

        $this->app->singleton('FilterGenerator',function($app){
            return new \Nette\Admin\FilterGenerator();
        });


    }

    public function loadSettings()
    {
        //Default Settings System
        $siteSettings = [];
        if(File::exists(base_path('settings.php'))) {
            $siteSettings = require_once base_path('settings.php');
        }

        if(is_array($siteSettings)) {
            foreach ($siteSettings as $key => $setting) {
                Config::set('set.' . $key, $setting);
            }
        }
    }


    public function registerPolicies()
    {
        foreach ($this->policies as $key => $value) {
            Gate::policy($key, $value);
        }
    }

    /**
     * Get the policies defined on the provider.
     *
     * @return array
     */
    public function policies()
    {
        return $this->policies;
    }
}
