<?php
namespace Nette\Admin\Models;

if (trait_exists('\Nette\ElasticSearch\Traits\ModelElasticSearch')) {
    class Page extends PageBase
    {
        protected $table = 'pages';

        use \Nette\ElasticSearch\Traits\ModelElasticSearch;

        public $elasticFields = [
            'id',
            'name',
            'slug',
            'content',
            'photo_id',
            'status',
            'lock',
            'order_number',
            'meta',
            'key',
            'subkey',
            'created_at',
            'updated_at'
        ];

        public $elasticRelations = ['photo'];

        public $mappingProperties = [
            'name' => [
                'type' => 'text',
                'analyzer' => 'turkish'
            ],
            'slug' => [
                'type' => 'text',
                'analyzer' => 'nGram_analyzer'
            ],
            'content' => [
                'type' => 'text',
                'analyzer' => 'turkish'
            ],
            'photo_id' => [
                'type' => 'integer'
            ],
            'status' => [
                'type' => 'boolean'
            ],
            'lock' => [
                'type' => 'boolean'
            ],
            'order_number' => [
                'type' => 'integer'
            ],
            'key' => [
                'type' => 'text'
            ],
            'subkey' => [
                'type' => 'text'
            ]
        ];

        function getIndexName()
        {
            return static::getTable();
        }
    }
} else {
    class Page extends PageBase
    {

    }
}
