<?php

namespace Nette\Admin\Models;

use Illuminate\Database\Eloquent\Model;

class AdminGroup extends Model
{
    protected $table = 'admin_groups';
    protected $fillable = [
        'name',
        'permissions'
    ];

    public static $rules = [
        'name' => 'required|max:255'
    ];

    public static $attr = [
        'name'         => 'İsim',

    ];


    public function Admins()
    {
        return $this->belongsToMany('Nette\Admin\Models\Admin','admins_admin_groups','group_id','admin_id');
    }
}

