<?php

namespace Nette\Admin\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\SoftDeletes;

class Admin extends Authenticatable
{
    protected $table = 'admins';

    use SoftDeletes;

    protected $fillable = [
        'name', 'email', 'password', 'status'
    ];


    protected $hidden = [
        'password', 'remember_token',
    ];

    public static $rules = [
        'name' => 'required|max:255',
        'email' => 'required|email|max:255',
        'password' => 'min:6|confirmed',
    ];

    public static $attr = [
        'name' => 'İsim',
        'email' => 'E-Posta',
        'password' => 'Şifre',
    ];

    public static $checks = [
        'status'
    ];


    public function groups()
    {
        return $this->belongsToMany('Nette\Admin\Models\AdminGroup', 'admins_admin_groups', 'admin_id', 'group_id');
    }

    public function Permissions()
    {
        $permissions = [];
        $permissions["superuser"] = $this->isSuperUser();
        $permissionGroups = $this->groups()->get()->toArray();

        if (is_array($permissionGroups)) {
            foreach ($permissionGroups as $permissionGroup) {
                if ($permissionGroup["permissions"]) {
                    $permissions = array_merge($permissions, json_decode($permissionGroup["permissions"], true));
                }
            }
        }

        return $permissions;

    }

    public function isSuperUser()
    {
        // Dua ve Rahmetleri aykut@nette.com.tr ye bekliyorum.
        // IF permission is not null
        //      (if permission property superuser exits)
        //          ((return superuser == true))
        return ($this->permissions != "") ? ((property_exists(json_decode($this->permissions), 'superuser')) ? (json_decode($this->permissions)->superuser == true) : false) : false;
    }

    public static function getChainOptions()
    {
        return self::all()->pluck('name', 'id')->toArray();
    }

    public static function getChainValues($id)
    {
        return [1, 10, 11, 12, 13, 14, 15, 34];
    }

}