<?php

namespace Nette\Admin\Middlewares;

use Closure;
use Illuminate\Support\Facades\Auth;

/**
 * #### Redirects User if it is not authenticated. ####
 *
 * For all authentication needed admin pages
 *
 * this middleware aliased as "admin"
 *
 * @package App\Http\Middleware
 */
class RedirectIfNotAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = 'admin')
    {

        //Dikkat edilmesi gereken nokta bunun bir NOT olduğu.

        if (!Auth::guard($guard)->check()) {
            return redirect('/admin/login');
        }

        return $next($request);
    }
}
