<?php


namespace Nette\Admin\Data;


use Nette\Admin\Models\Page;
use Redis;

class PageData
{

    public function getPage($slug)
    {
        return Page::searchByQuery([
            'bool' => [
                "must" => [
                    [
                        'term' => [
                            'slug' => $slug
                        ]
                    ],
                    [
                        'term' => [
                            'status' => true
                        ]
                    ],
                    [
                        'term' => [
                            'lock' => false
                        ]
                    ]
                ]

            ]
        ])->first();
    }

    public function getPageWithKey($key)
    {
        return Page::searchByQuery([
            'bool' => [
                "must" => [
                    [
                        'term' => [
                            'key' => $key
                        ]
                    ],
                    [
                        'term' => [
                            'status' => true
                        ]
                    ]
                ]

            ]
        ])->first();
    }

}