<?php

namespace Nette\Admin\Controllers;

use function foo\func;
use Nette\Admin\Controllers\AdminBaseController as AdminBaseController;
use Illuminate\Http\Request;
use Cache;
use Nette\Admin\Models\Admin;
use Spatie\Activitylog\Models\Activity;

class LogController extends AdminBaseController
{

    public $cPermission = 'log.view';
    public function index()
    {
        $this->check('cPermission');
        //dd(session('success'));
        return view('admin::log');
    }

    public function data()
    {
        $this->check('cPermission');
        $draw = request()->draw;

        $start = request()->start;
        $length = request()->length;

        $search = request()->search['value'] ?? null;
        $searchIDs = false;
        if($search){
            $searchIDs = Admin::where('name', 'like', '%' . $search . '%')->orderBy('id','ASC')->get()->pluck('id')->toArray();
        }

        $orderColumnIndex = request()->order[0]['column'] ?? 0;
        $orderColumn =        request()->columns[$orderColumnIndex]['data'] ?? 'id';
        $orderSort = request()->order[0]['dir'] ?? 'desc';

        $activityCount = Activity::whereIn('description', ['login', 'logout'])->count();
        $activities = Activity::whereIn('description', ['login', 'logout'])->when($searchIDs, function ($q, $searchIDs) {
            return $q->whereIn('causer_id',$searchIDs);
        })->orderBy($orderColumn,$orderSort)->offset($start)->take($length)->get();


        $data = [];
        $activities->map(function ($activity) use (&$data) {
            $dataitem = [];

            $action = $activity->description == 'login' ? '<span style="color:green; font-size:15px;">Giriş</span>' : '<span style="color:red; font-size:15px;">Çıkış</span>';

            $dataitem['id'] = $activity->id;
            $dataitem['name'] = $activity->causer->name;
            $dataitem['ip'] = $activity->properties['ip'];
            $dataitem['description'] = $action;
            $dataitem['created_at'] = $activity->created_at->format('d-m-Y H:i:s');

            $data[] = $dataitem;

        });



        return response()->json(
            [
                'draw' => intval($draw),
                'iTotalRecords' => count($data),
                'iTotalDisplayRecords' => $activityCount,
                'data' => $data
            ]

        );
    }


}
