<?php

namespace Nette\Admin\Controllers;

use Nette\Admin\Controllers\AdminBaseController as AdminBaseController;
use Illuminate\Http\Request;
use Cache;
use Analytics;
use Carbon\Carbon;
use ModuleLoader;
use Spatie\Analytics\Period;

class IndexController extends AdminBaseController
{

    public $cJSModules = [
        'admin::_js.dashboard'
    ];

    public function index()
    {
        //dd(session('success'));
        return view('admin::index');
    }

    public function clearCache(Request $request)
    {
        $cacheClear = Cache::flush();

        $loadedModules = ModuleLoader::getModuleData();

        $cacheRefreshers = [];

        foreach ($loadedModules as $loadedModule){
            $cacheRefreshers = array_merge($cacheRefreshers,$loadedModule['cache']);
        }

        if(count($cacheRefreshers)){
            foreach ($cacheRefreshers as $cacheRefresher){
                $result = $cacheRefresher();
            }
        }


        if ($cacheClear) {
            $request->session()->flash('success', 'Önbellek başarıyla temizlendi!');
        } else {
            $request->session()->flash('error', 'Önbellekte nesne yok!');
        }

        return redirect()->back();

    }

    public function analyticsData(Request $request)
    {
        $this->checkFromString('analytics.view');
        if ($request->ajax()) {
            $analyticsData = Analytics::fetchTotalVisitorsAndPageViews(Period::days(7));
            if ($analyticsData) {


                $data = [];
                $data['views'][] = 'Sayfa Görüntülenme';
                $data['visitors'][] = 'Yeni Zİyaretçi';
                foreach ($analyticsData as $analyticsDatum) {
                    $data['categories'][] = $analyticsDatum['date']->format("l");
                    $data['views'][] = $analyticsDatum['pageViews'];
                    $data['visitors'][] = $analyticsDatum['visitors'];
                }
                return response()->json(['status' => 'success', 'data' => $data]);

            }

            return response()->json(['status', 'fail', 'message' => 'Somethings wrong']);
        }

    }

    private function stringToColorCode($str)
    {
        $code = dechex(crc32($str));
        $code = substr($code, 0, 6);
        return $code;
    }

    public function browserData(Request $request)
    {
        $this->checkFromString('analytics.view');
        if ($request->ajax()) {
            $browserData = Analytics::performQuery(
                Period::days(7),
                'ga:sessions',
                [
                    'metrics' => 'ga:users',
                    'dimensions' => 'ga:browser'
                ]
            );
            $platformData = Analytics::performQuery(
                Period::days(7),
                'ga:sessions',
                [
                    'metrics' => 'ga:users',
                    'dimensions' => 'ga:operatingSystem'
                ]
            );
            $data = [
                'browser' => [],
                'platform' => [],
            ];
            foreach ($browserData as $analyticsDatum) {
                $datumElement = new \stdClass();
                $datumElement->browser = $analyticsDatum[0];
                $datumElement->value = $analyticsDatum[1];
                $datumElement->color = '#'.$this->stringToColorCode($analyticsDatum[0]);
                $data['browser'][] = $datumElement;
            }
            foreach ($platformData as $analyticsDatum) {
                $datumElement = new \stdClass();
                $datumElement->platform = $analyticsDatum[0];
                $datumElement->value = $analyticsDatum[1];
                $datumElement->color = '#'.$this->stringToColorCode($analyticsDatum[0]);
                $data['platform'][] = $datumElement;
            }

            return response()->json(['status' => 'success', 'data' => $data]);
        } else {
            return response()->json(['status', 'fail', 'message' => 'Somethings wrong']);
        }
    }

    public function visitorData(Request $request)
    {
        $this->checkFromString('analytics.view');
        if ($request->ajax()) {
            $analyticsData = Analytics::fetchUserTypes(Period::days(1));
            if ($analyticsData) {
                return response()->json(['status' => 'success', 'data' => $analyticsData]);
            }
        }
        return response()->json(['status', 'fail', 'message' => 'Somethings wrong']);
    }

    public function referralData(Request $request)
    {
        if ($request->ajax()) {
            $analyticsData = Analytics::fetchTopReferrers(Period::days(1), 12);
            if ($analyticsData) {
                return response()->json(['status' => 'success', 'data' => $analyticsData]);
            }
        }
        return response()->json(['status', 'fail', 'message' => 'Somethings wrong']);
    }

    public function geoVisitors(Request $request)
    {
        if ($request->ajax()) {
            $analyticsData = Analytics::performQuery(Period::days(11), 'ga:sessions', [
                'metrics' => 'ga:users',
                'dimensions' => 'ga:country'
            ]);

            if ($analyticsData) {

                $geoData = [];
                foreach ($analyticsData->rows as $row) {
                    $geoData[] = [
                        $row[0], $row[1]
                    ];
                }

                return response()->json(['status' => 'success', 'data' => $geoData]);
            }
        }
    }

    public function socialMedia(Request $request)
    {
        if ($request->ajax()) {

            $analyticsDataToday = Analytics::performQuery(Period::create(Carbon::today(), Carbon::today()->addHours(23)->addMinutes(59)->addSeconds(59)), 'ga:sessions', [
                'metrics' => 'ga:sessions',
                'dimensions' => 'ga:socialNetwork'
            ]);

            $analyticsDataYesterday = Analytics::performQuery(Period::create(Carbon::yesterday(), Carbon::yesterday()->addHours(23)->addMinutes(59)->addSeconds(59)), 'ga:sessions', [
                'metrics' => 'ga:sessions',
                'dimensions' => 'ga:socialNetwork'
            ]);

            return response()->json(['status' => 'success', 'data' => ['today' => $analyticsDataToday->rows, 'yesterday' => $analyticsDataYesterday->rows]]);

        }
    }

    public function searchKeyword(Request $request)
    {
        if ($request->ajax()) {

            $analyticsData = Analytics::performQuery(Period::days(1), 'ga:sessions', [
                'metrics' => 'ga:sessions',
                'dimensions' => 'ga:keyword',
                'max-results' => 6
            ]);

            if ($analyticsData) {
                return response()->json(['status' => 'success', 'data' => $analyticsData->rows]);
            }

            return response()->json(['status', 'fail', 'message' => 'Somethings wrong']);
        }
    }



}
