<?php

namespace Nette\Admin\Controllers;

use Nette\Admin\Controllers\AdminBaseController as AdminBaseController;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Auth;
use Illuminate\Http\Request;

/**
 * Class AuthController
 * @package Nette\Admin\Controllers
 */
class AuthController extends AdminBaseController
{
    use AuthenticatesUsers;

    /**
     * Landing page after successfull redirection
     *
     * @return string
     */
    protected function redirectTo()
    {

        return '/admin/';
    }

    /**
     * @param Request $request
     * @return array
     */
    protected function credentials(Request $request)
    {
        $credentials = $request->only($this->username(), 'password');
        $credentials['status'] = 1;

        return $credentials;

    }


    /**
     * Renders Login Form
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function showLoginForm()
    {
        return view('admin::auth.login');
    }

    /**
     * Renders Login Page
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function getLogin()
    {
        return $this->showLoginForm();
    }

    /**
     * Process Login Form data with request
     *
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse|\Illuminate\Http\RedirectResponse|\Illuminate\Http\Response
     */
    public function postLogin(Request $request)
    {
        return $this->login($request);
    }

    /**
     * Laravel specified admin Guard
     *
     * @return \Illuminate\Contracts\Auth\Guard|\Illuminate\Contracts\Auth\StatefulGuard
     */
    protected function guard()
    {
        return Auth::guard('admin');
    }


    /**
     * Proceed logout
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function logout(Request $request)
    {
        activity()->withProperties(['ip' => request()->ip()])->log('logout');

        $this->guard()->logout();

        $request->session()->flush();

        $request->session()->regenerate();

        return redirect('/admin');
    }

    /**
     * Redirection Mechanism.
     *
     * if redirectTo method exits run it
     * if not
     *      if redirectTo propert exits redirect to it
     *      if not redirect /home
     *
     * @return string
     */
    public function redirectPath()
    {

        if (method_exists($this, 'redirectTo')) {
            return $this->redirectTo();
        }

        return property_exists($this, 'redirectTo') ? $this->redirectTo : '/home';
    }

    /**
     * Post successfull login method
     *
     * @param Request $request
     * @param         $user
     * @return \Illuminate\Http\RedirectResponse
     */
    protected function authenticated(Request $request, $user)
    {

        activity()->withProperties(['ip' => request()->ip()])->log('login');
        return redirect()->to($this->redirectPath());
    }

}