<?php

namespace Nette\Admin\Controllers;


use Validator;

use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController;
use Nette\Admin\Models\Admin;
use Nette\Admin\Models\AdminGroup;
use Nette\Admin\Requests\Admins\CreateRequest;
use Nette\Admin\Requests\Admins\UpdateRequest;

class AdminsController extends AdminBaseController
{

    public $cMenuKey = 'admins';
    public $cModel = Admin::class;
    public $cModelName = 'Yöneticiler';

    public $cKey = 'admins';

    public $cIndexBlade = null;
    public $cIndexRoute = 'admin.admins.index';
    public $cIndexTitle = 'Liste';
    public $cIndexPermission = 'admins.view';

    //region Edit Settings
    public $cEdit = true;
    public $cEditRoute = 'admin.admins.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.admins.update';
    public $cEditPermission = 'admins.edit';
    //endregion

    //region Create Settings
    public $cCreate = true;
    public $cCreateRoute = 'admin.admins.create';
    public $cCreateTitle = 'Yeni';
    public $cCreateMethodRoute = 'admin.admins.store';
    public $cCreatePermission = 'admins.create';
    public $cCreateBlade = 'Admin::create';
    //endregion

    //region Publish Settings
    public $cPublish = true;
    public $cPublishRoute = 'admin.admins.active';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'admins.active';
    //endregion

    public $cDelete = true;
    public $cDeleteRoute = 'admin.admins.destroy';
    public $cDeleteTitle = 'Sil';
    public $cDeletePermission = 'admins.delete';

    public $cFields = [
        'id' => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name' => ['name' => 'Yönetici Adı'],
        'email' => ['name' => 'E-Posta'],
        'created_at' => ['name' => 'Eklenme Tarih', 'sortable' => true, 'size' => 'medium']
    ];

    public $cFieldMutators = [
        'name' => ['method' => 'frontUrl', 'parameter' => 'object'],
        'created_at' => 'globalDate'
    ];

    public $cFilterable = true;
    public $filters = [
        'id' => [
            'name' => 'ID',
            'type' => 'text',
            'operator' => 'equal'
        ],
        'name' => [
            'name' => 'İsim',
            'type' => 'text',
            'operator' => 'like'
        ],
        'email' => [
            'name' => 'E-posta adresi',
            'type' => 'text',
            'operator' => 'like'
        ],
        'status' => [
            'name' => 'Durumu',
            'type' => 'radio',
            'operator' => 'equal',
            'values' => [1 => 'Aktif', 0 => 'Pasif']
        ],
    ];

    public function __construct()
    {
        parent::__construct();

    }

    public function create()
    {
        $groups = AdminGroup::all()->toArray();
        return view('admin::admins.create')
            ->with('method', 'POST')
            ->with('methodURL', route('admin.admins.store'))
            ->with('groups', $groups);
    }

    public function active(Request $request, $id)
    {
        $this->check('cPublishPermission');
        if (!$id) {
            abort(404);
        }

        $result = result(false);
        $input = $request->all();
        $item = Admin::findOrFail($id);
        $itemStatus = (bool)$item->status;

        $item->status = !$itemStatus;

        if (!$item->save()) {
            $result = result(false, 'failed');
        } else {
            $result = result(true, $item->status ? 'published' : 'unpublished');
        }
        return response()->json($result);

    }

    public function store(CreateRequest $request)
    {
        $input = $request->all();
        $obj = Admin::create($input);

        //Şifre Boş değilse Değiştir
        if ($request->input('password') != '') {
            $obj->password = bcrypt($request->input('password'));
        }

        //Superuser Kontrolü
        if (!is_null($request->input('superuser'))) {
            if (admin()->isSuperUser()) {
                $obj->permissions = json_encode(['superuser' => $request->input('superuser', 0)]);
            }
        } else {
            $obj->permissions = null;
        }

        if ($obj->save()) {

            //Sync Groups

            $groups = $request->input('groups', []);
            $obj->groups()->sync($groups);

            //FIRE EVENT

            $request->session()->flash('success', 'Yönetici Başarıyla Oluşturuldu');
        }

        return redirect()->route('admin.admins.index');
    }


    public function edit($id)
    {
        //Admini Getir
        $admin = Admin::with('groups')->findOrFail($id);

        //AdminGruplarını getir
        $groups = AdminGroup::all()->toArray();

        //Adminin Gruplarını getir
        $adminsGroups = $admin->groups->pluck('id')->toArray();

        //Tüm grupları adminin gruplarıyla karşılaştırıp dahil olanları checked olarak yeniden tanımla.
        array_walk($groups, function (&$value, &$key) use ($adminsGroups) {
            $value = ["id" => $value["id"], "name" => $value["name"], "checked" => in_array($value["id"], $adminsGroups) ? true : false];
        });

        return view('admin::admins.create')
            ->with('item', $admin)
            ->with('groups', $groups)
            ->with('method', 'PUT')
            ->with('methodURL', route('admin.admins.update',['id'=>$id]));
    }


    public function update(UpdateRequest $request, $id)
    {

        $input = $request->except(['password', 'superuser', 'groups', 'save']);

        $obj = Admin::findOrFail($id);
        $obj->update($input);

        # - Şifre Boş değilse Değiştir
        if ($request->input('password') != '') {
            $obj->password = bcrypt($request->input('password'));
        }

        # - Superuser Kontrolü
        if (!is_null($request->input('superuser'))) {
            if (admin()->isSuperUser()) {
                $obj->permissions = json_encode(['superuser' => $request->input('superuser', 0)]);
            }
        } else {
            $obj->permissions = null;
        }

        if ($obj->save()) {
            //Sync Groups
            $groups = $request->input('groups', []);
            $obj->groups()->sync($groups);
            //FIRE EVENT
            $request->session()->flash('success', 'Yönetici Güncellendi');
            return redirect()->route('admin.admins.edit', $id);
        }

    }

    public function destroy(Request $request, $id)
    {
        $result = result(false);
        $admin = Admin::findOrFail($id);
        if (!$admin->delete()) {
            $result = result(false);
        } else {
            $result = result(true);
        }
        return response()->json($result);
    }

}
