<?php

namespace Nette\Admin\Console;

use Cocur\Slugify\Bridge\ZF2\Module;
use Illuminate\Console\Command;
use ModuleLoader;
use File;

class SyncPackageDb extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'nette:sync';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync Migrations & Database Seeders';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
       $moduleData = collect(ModuleLoader::getModuleData());

       $migrationPath = ModuleLoader::getDBMigrationPath();
       $migrationFiltered = $moduleData->filter(function($module,$moduleKey){
           return ($module['type'] == 'local' && isset($module['migrations']) && count($module['migrations'] ?? []) > 0);
       });

       foreach ($migrationFiltered as $key => $module){
           $this->warn($key . ' migrations found');
           foreach ($module['migrations'] ?? [] as $migration){
               if(File::exists($migration)){
                   File::copy($migration,$migrationPath.DIRECTORY_SEPARATOR.basename($migration));
               }
           }
       }

        $seedPath = ModuleLoader::getDBSeedPath();
        $seedFiltered = $moduleData->filter(function($module,$moduleKey){
            return ($module['type'] == 'local' && isset($module['seeds']) && count($module['seeds'] ?? []) > 0);
        });

        foreach ($seedFiltered as $key => $module){
            $this->warn($key . ' seeds found');
            foreach ($module['seeds'] ?? [] as $seed){
                if(File::exists($seed)){
                    File::copy($seed,$seedPath.DIRECTORY_SEPARATOR.basename($seed));
                }
            }
        }




    }
}
