<?php

Route::group(['prefix' => 'admins', 'as' => 'admins.'], function () {
    Route::get('/',                                 ['as' => 'index',   'uses' => 'Nette\Admin\Controllers\AdminsController@index']);
    Route::get('/create',                           ['as' => 'create',  'uses' => 'Nette\Admin\Controllers\AdminsController@create']);
    Route::post('/',                                ['as' => 'store',   'uses' => 'Nette\Admin\Controllers\AdminsController@store']);
    Route::post('/{id}/active',                     ['as' => 'active',  'uses' => 'Nette\Admin\Controllers\AdminsController@active']);
    Route::get('/{id}/edit',                        ['as' => 'edit',    'uses' => 'Nette\Admin\Controllers\AdminsController@edit']);
    Route::match(['put', 'patch'], '/{id}/update',  ['as' => 'update',  'uses' => 'Nette\Admin\Controllers\AdminsController@update']);
    Route::delete('/{id}',                          ['as' => 'destroy', 'uses' => 'Nette\Admin\Controllers\AdminsController@destroy']);
});

Route::group(['prefix' => 'admingroups', 'as' => 'admingroups.'], function () {
    Route::get('/',                                 ['as' => 'index',   'uses' => 'Nette\Admin\Controllers\AdminGroupsController@index']);
    Route::get('/create',                           ['as' => 'create',  'uses' => 'Nette\Admin\Controllers\AdminGroupsController@create']);
    Route::post('/',                                ['as' => 'store',   'uses' => 'Nette\Admin\Controllers\AdminGroupsController@store']);
    Route::get('/{id}/edit',                        ['as' => 'edit',    'uses' => 'Nette\Admin\Controllers\AdminGroupsController@edit']);
    Route::match(['put', 'patch'], '/{id}/update',  ['as' => 'update',  'uses' => 'Nette\Admin\Controllers\AdminGroupsController@update']);
    Route::delete('/{id}',                          ['as' => 'destroy', 'uses' => 'Nette\Admin\Controllers\AdminGroupsController@destroy']);
});

Route::group(['prefix' => 'page', 'as' => 'page.'], function () {
    Route::get('/',                                 ['as' => 'index',   'uses' => 'Nette\Admin\Controllers\PageController@index']);
    Route::get('/create',                           ['as' => 'create',  'uses' => 'Nette\Admin\Controllers\PageController@create']);
    Route::post('/',                                ['as' => 'store',   'uses' => 'Nette\Admin\Controllers\PageController@store']);
    Route::get('/{id}/edit',                        ['as' => 'edit',   'uses' => 'Nette\Admin\Controllers\PageController@edit']);
    Route::match(['put', 'patch'], '/{id}/update',  ['as' => 'update',  'uses' => 'Nette\Admin\Controllers\PageController@update']);
    Route::post('/{id}/publish',                    ['as' => 'publish',   'uses' => 'Nette\Admin\Controllers\PageController@publish']);
    Route::delete('/{id}',                          ['as' => 'destroy', 'uses' => 'Nette\Admin\Controllers\PageController@destroy']);
    Route::post('/batchdestroy',                    ['as' => 'batchdestroy', 'uses' => 'Nette\Admin\Controllers\PageController@batchDestroy']);
    Route::post('/orderable',                       ['as' => 'orderable', 'uses' => 'Nette\Admin\Controllers\PageController@orderable']);
    Route::get('/{id}',                             ['as' => 'show',    'uses' => 'Nette\Admin\Controllers\PageController@show']);
    Route::post('/{id}/ordermedia',                 ['as' => 'ordermedia',   'uses' => 'Nette\Admin\Controllers\PageController@orderMedia']);
    Route::post('/{id}/updatemedia',                ['as' => 'updatemedia',   'uses' => 'Nette\Admin\Controllers\PageController@updateMedia']);
    Route::post('/{id}/deletemedia',                ['as' => 'deletemedia',   'uses' => 'Nette\Admin\Controllers\PageController@deleteMedia']);
});

Route::group(['prefix' => 'analytics', 'as' => 'analytics.'], function () {
    Route::post('/visitors',    ['as' => 'visitors',    'uses' => 'Nette\Admin\Controllers\IndexController@visitorData']);
    Route::post('/data',        ['as' => 'data',        'uses' => 'Nette\Admin\Controllers\IndexController@analyticsData']);
    Route::post('/browser',        ['as' => 'browser',        'uses' => 'Nette\Admin\Controllers\IndexController@browserData']);



    Route::post('/referrals',   ['as' => 'referrals', 'uses' => 'Nette\Admin\Controllers\IndexController@referralData']);
    Route::post('/location',    ['as' => 'referrals', 'uses' => 'Nette\Admin\Controllers\IndexController@geoVisitors']);
    Route::post('/keywords',    ['as' => 'referrals', 'uses' => 'Nette\Admin\Controllers\IndexController@searchKeyword']);
    Route::post('/social',      ['as' => 'referrals', 'uses' => 'Nette\Admin\Controllers\IndexController@socialMedia']);
});

Route::get('/log',      ['as' => 'log.index',   'uses' => 'Nette\Admin\Controllers\LogController@index']);
Route::get('/logdata',  ['as' => 'log.data',    'uses' => 'Nette\Admin\Controllers\LogController@data']);


Route::get('/settings', ['as' => 'settings.index', 'uses' => 'Nette\Admin\Controllers\SettingsController@showSettings']);
Route::post('/settings', ['as' => 'settings.save', 'uses' => 'Nette\Admin\Controllers\SettingsController@saveSettings']);
Route::get('/clearcache', ['as' => 'clearcache', 'uses' => 'Nette\Admin\Controllers\IndexController@clearCache']);
