
<?php $current_menu = "contact"; ?>
<?php $__env->startSection('metaTags'); ?>
    <?php $pageTitle = seoTitle($page->meta,$page->{'name_'._clang()}); ?>
    <?php $pageDescription = seoDescription($page->meta,$page->{'content_'._clang()}); ?>
    <?php $pageImage = $page->getPhoto(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
    <div class="sub-page">
        <div class="sub-hero" style="background-image:url(<?php echo e($page->getPhoto()); ?>);">
            <div class="wrap">
                <div class="page-title tac"><?php echo e($page->name); ?></div>
                <div class="breadcrumb">
                    <section>
                        <a href="<?php echo e(route("front.home")); ?>"><?php echo e(trans("breadcrumb.home")); ?></a>
                        <i>/</i>
                        <strong><?php echo e($page->name); ?></strong>
                    </section>
                </div>
            </div>
        </div>
        <div class="mask"><img src="<?php echo e(asset("images/mask-hero.png")); ?>" alt=""/></div>
    </div>

    <div class="w100 top-100 bottom-100">

        <div class="wrap">

            <div class="block-flexed bottom-100">
                <div class="flex-left">
                    <div class="medium-title space-bottom"><?php echo e($page->spot); ?></div>
                    <div class="page-text"><?php echo $page->content; ?></div>
                </div>
                <div class="flex-right">
                    <div class="contact-info">
                        <section>
                            <img src="<?php echo e(asset("images/icon-phone.png")); ?>" alt="">
                            <small><?php echo e(trans("contact.phone")); ?></small>
                            <article><strong><?php echo e($configs["ph1"]); ?></strong></article>
                        </section>
                        <?php if($configs["ph2"]): ?>
                            <section>
                                <img src="<?php echo e(asset("images/icon-phone.png")); ?>" alt="">
                                <small><?php echo e(trans("contact.phone")); ?></small>
                                <article><strong><?php echo e($configs["ph2"]); ?></strong></article>
                            </section>
                        <?php endif; ?>
                        <section>
                            <img src="<?php echo e(asset("images/icon-mail.png")); ?>" alt="">
                            <small><?php echo e(trans("contact.email")); ?></small>
                            <article><?php echo e($configs["mail"]); ?></article>
                        </section>
                        <section>
                            <img src="<?php echo e(asset("images/icon-pin.png")); ?>" alt="">
                            <small><?php echo e(trans("contact.address")); ?></small>
                            <article><?php echo e($configs["adr"]); ?>/ BURSA</article>
                        </section>
                    </div>
                </div>
            </div>

            <div class="block-flexed bottom-100">
                <div class="flex-left">
                    <div class="medium-title space-bottom"><?php echo e(trans("contact.ctitle")); ?></div>
                    <div class="page-text"><?php echo trans("contact.ccontent"); ?>

                    </div>
                    <div class="contact-form">
                        <div class="inner-15">
                            <?php echo html()->form('POST',route('front.contact_submit'))->open(); ?>


                            <div class="form-item">
                                <?php echo html()->text('name')->placeholder(trans('contact.name'))->required(true)->addClass('input'); ?>

                            </div>

                            <div class="form-item">
                                <?php echo html()->email('email')->placeholder(trans('contact.mail'))->required(true)->addClass('input'); ?>

                            </div>

                            <div class="form-item">
                                <?php echo html()->text('phone')->placeholder(trans('contact.phone_number'))->required(true)->addClass('input'); ?>

                            </div>

                            <div class="form-item">
                                <?php echo html()->text('subject')->placeholder(trans('contact.subject'))->required(true)->addClass('input'); ?>

                            </div>

                            <div class="form-item w100">
                                <?php echo html()->textarea('body')->placeholder(trans('contact.messages'))->required(true)->addClass('input')->attributes(['rows' => 5])->style('height:100px;'); ?>

                            </div>

                            
                            <div class="form-item w100">
                                <button id="send" class="button"><?php echo e(trans("contact.send")); ?></button>
                            </div>
                            <?php echo html()->form()->close(); ?>

                        </div>
                    </div>
                </div>
                <div class="flex-right">
                    <div class="contact-map">
                        <iframe src="<?php echo $configs["mk"]; ?>"
                                width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"
                                referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>

        </div>

    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("main", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/porsionperakende.yeniproje.com/httpdocs/resources/views/front/contact/index.blade.php ENDPATH**/ ?>