<!DOCTYPE html>
<html lang="<?php echo e(_clang()); ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="content-language" content="tr-TR"/>
    <?php if(array_key_exists('metaTags', View::getSections())): ?>
        <?php echo $__env->yieldContent('metaTags'); ?>
    <?php else: ?>
        <?php $pageTitle = _config('site_name'); ?>
        <?php $pageIndex = 'index follow'; ?>
        <?php $pageDescription = trans('meta.title'); ?>
        <?php $pageImage = _asset('images/logo.png'); ?>
    <?php endif; ?>
    <?php echo $__env->make('front._.meta', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no"/>
    <link rel="stylesheet" href="<?php echo asset('css/app.css'); ?>">
    <link rel="stylesheet" href="<?php echo asset('css/custom.css'); ?>">
    <link rel="shortcut icon" href="<?php echo asset('favicon.png'); ?>" type="image/x-icon"/>
</head>

<body>

<div class="porsion">
    <?php echo $__env->make("front._.header", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if($current_menu == "home"): ?>
        <div id="fullpage"><?php endif; ?>
            <?php echo $__env->yieldContent("content"); ?>
            <?php echo $__env->make("front._.footer", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php if($current_menu == "home"): ?></div>
    <?php endif; ?>
</div>

<?php echo $__env->make("front._.cookie", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="<?php echo asset('js/app.js'); ?>"></script>
<script type="text/javascript">
    // Parallax nesnesini başlat
    var scenes = document.getElementsByClassName('scene');
    for (var i = 0; i < scenes.length; i++) {
        var parallaxInstance = new Parallax(scenes[i]);
    }
</script>
<?php echo $__env->yieldContent('scripts'); ?>
<?php echo $__env->make('front._.status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /var/www/vhosts/porsionperakende.yeniproje.com/httpdocs/resources/views/main.blade.php ENDPATH**/ ?>