
<?php $current_menu = 'search'; ?>
<?php $__env->startSection('content'); ?>
    <div class="sub-page">
        <div class="sub-hero" style="background-image:url(<?php echo e($page->getPhoto()); ?>);">
            <div class="wrap">
                <div class="page-title tac"><?php echo e($page->name); ?></div>
                <div class="breadcrumb">
                    <section>
                        <a href="<?php echo e(route("front.home")); ?>"><?php echo e(trans("breadcrumb.home")); ?></a>
                        <i>/</i>
                        <strong><?php echo e($page->name); ?></strong>
                    </section>
                </div>
            </div>
        </div>
        <div class="mask"><img src="<?php echo e(asset("images/mask-hero.png")); ?>" alt=""/></div>
    </div>

    <div class="w100 top-50 bottom-100">

        <div class="wrap-slim">

            <div class="search-list">
                <ul>
                    <?php $__currentLoopData = $combinedResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(class_basename(get_class($result)) == "Product"): ?>
                            <li>
                                <a href="<?php echo e(route("front.product", ["category_slug" => $result->category->slug, "slug" => $result->slug])); ?>">
                                    <div class="search-list-picture"><img
                                                src="<?php echo e($result->getCover()); ?>"
                                                alt=""/></div>
                                    <div class="search-list-content">
                                        <div class="search-list-title"><?php echo e($result->name); ?></div>
                                        <div class="search-list-info">
                                            <i><?php echo e($result->category->name); ?></i>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        <?php elseif(class_basename(get_class($result)) == "Category"): ?>
                            <li>
                                <a href="<?php echo e(route("front.category", ["slug" => $result->slug])); ?>">
                                    <div class="search-list-picture"><img
                                                src="<?php echo e($result->getBanner()); ?>"
                                                alt=""/></div>
                                    <div class="search-list-content">
                                        <div class="search-list-title"><?php echo e($result->name); ?></div>
                                        <div class="search-list-info">
                                            <i><?php echo e(trans("search.category")); ?></i>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        <?php elseif(class_basename(get_class($result)) == "Faq"): ?>
                            <li>
                                <a href="<?php echo e(route("front.faq")); ?>">
                                    <div class="search-list-content">
                                        <div class="search-list-title"><?php echo e($result->name); ?></div>
                                        <div class="search-list-info">
                                            <i><?php echo e(trans("search.faq")); ?></i>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        <?php elseif(class_basename(get_class($result)) == "Article"): ?>
                            <?php if($result->category->parent_id == 3 ): ?>
                                
                                <li>
                                    <a href="<?php echo e(route("front.blog", ["slug" => $result->slug])); ?>">
                                        <div class="search-list-picture"><img
                                                    src="<?php echo e($result->getPhoto()); ?>"
                                                    alt=""/></div>
                                        <div class="search-list-content">
                                            <div class="search-list-title"><?php echo e($result->name); ?></div>
                                            <div class="search-list-info">
                                                <i><?php echo e(trans("search.blog")); ?></i>
                                                <span><?php echo e($result->created_at->format("d.m.Y")); ?></span>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                            <?php elseif($result->category->id == 4): ?>
                                
                                <li>
                                    <a href="<?php echo e(route("front.new", ["slug" => $result->slug])); ?>">
                                        <div class="search-list-picture"><img
                                                    src="<?php echo e($result->getPhoto()); ?>"
                                                    alt=""/></div>
                                        <div class="search-list-content">
                                            <div class="search-list-title"><?php echo e($result->name); ?></div>
                                            <div class="search-list-info">
                                                <i><?php echo e(trans("search.new")); ?></i>
                                                <span><?php echo e($result->created_at->format("d.m.Y")); ?></span>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                            <?php elseif($result->category->id == 5): ?>
                                
                                <li>
                                    <a href="<?php echo e(route("front.activity", ["slug" => $result->slug])); ?>">
                                        <div class="search-list-picture"><img
                                                    src="<?php echo e($result->getPhoto()); ?>"
                                                    alt=""/></div>
                                        <div class="search-list-content">
                                            <div class="search-list-title"><?php echo e($result->name); ?></div>
                                            <div class="search-list-info">
                                                <i><?php echo e(trans("search.activity")); ?></i>
                                                <span><?php echo e($result->created_at->format("d.m.Y")); ?></span>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                            <?php endif; ?>
                        <?php elseif(class_basename(get_class($result)) == "Redirect"): ?>
                            
                            <li>
                                <a href="<?php echo e(route("front.guide")); ?>">
                                    <div class="search-list-picture"><img
                                                src="<?php echo e($result->getPhoto()); ?>"
                                                alt=""/></div>
                                    <div class="search-list-content">
                                        <div class="search-list-title"><?php echo e($result->name); ?></div>
                                        <div class="search-list-info">
                                            <i><?php echo e(trans("search.guide")); ?></i>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        <?php endif; ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/porsionperakende.yeniproje.com/httpdocs/resources/views/front/search.blade.php ENDPATH**/ ?>