<?php

use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

Route::group(['as' => 'front.', 'namespace' => 'Front'], function () {
    Route::group(['prefix' => LaravelLocalization::setLocale(), 'middleware' => ['localizationRedirect', 'localize']], function () {
        Route::get('/', ['as' => 'home', 'uses' => 'HomeController@index']);

        /********************************************************************************************* Haberler*/
        Route::get(LaravelLocalization::transRoute('routes.blogs'), ['as' => 'blogs', 'uses' => 'BlogController@blogs']);
        Route::get(LaravelLocalization::transRoute('routes.blog'), ['as' => 'blog', 'uses' => 'BlogController@blog']);

        Route::get(LaravelLocalization::transRoute('routes.news'), ['as' => 'news', 'uses' => 'BlogController@news']);
        Route::get(LaravelLocalization::transRoute('routes.new'), ['as' => 'new', 'uses' => 'BlogController@new']);

        Route::get(LaravelLocalization::transRoute('routes.activities'), ['as' => 'activities', 'uses' => 'BlogController@activities']);
        Route::get(LaravelLocalization::transRoute('routes.activity'), ['as' => 'activity', 'uses' => 'BlogController@activity']);
        /********************************************************************************************* Haberler*/

        /********************************************************************************************* Statikler */
        Route::get(LaravelLocalization::transRoute('routes.location'), ['as' => 'location', 'uses' => 'LocationController@index']);
        Route::get(LaravelLocalization::transRoute('routes.guide'), ['as' => 'guide', 'uses' => 'GuideController@index']);
        Route::get(LaravelLocalization::transRoute('routes.faq'), ['as' => 'faq', 'uses' => 'FaqController@index']);
        /********************************************************************************************* Statikler */

        /********************************************************************************************* Ürünler */
        Route::get(LaravelLocalization::transRoute('routes.category'), ['as' => 'category', 'uses' => 'ProductController@category']);
        Route::get(LaravelLocalization::transRoute('routes.product'), ['as' => 'product', 'uses' => 'ProductController@product']);
        Route::get(LaravelLocalization::transRoute('routes.products'), ['as' => 'products', 'uses' => 'ProductController@products']);
        /********************************************************************************************* Ürünler */

        /********************************************************************************************* Kurumsal */
        Route::get(LaravelLocalization::transRoute('routes.about'), ['as' => 'about', 'uses' => 'CorporateController@about']);
        Route::get(LaravelLocalization::transRoute('routes.values'), ['as' => 'values', 'uses' => 'CorporateController@values']);
        Route::get(LaravelLocalization::transRoute('routes.quality'), ['as' => 'quality', 'uses' => 'CorporateController@quality']);
        Route::get(LaravelLocalization::transRoute('routes.why'), ['as' => 'why', 'uses' => 'CorporateController@why']);
        Route::get(LaravelLocalization::transRoute('routes.career'), ['as' => 'career', 'uses' => 'CorporateController@career']);
        /********************************************************************************************* Kurumsal */

        /********************************************************************************************* İletişim */
        Route::get(LaravelLocalization::transRoute('routes.contact'), ['as' => 'contact', 'uses' => 'FormController@index']);
        Route::post(LaravelLocalization::transRoute('routes.contact_submit'), ['as' => 'contact_submit', 'uses' => 'FormController@contactSubmit']);
        Route::post(LaravelLocalization::transRoute('routes.newsletter'), ['as' => 'newsletter', 'uses' => 'FormController@newsletterPost']);
        Route::get(LaravelLocalization::transRoute('routes.search'), ['as' => 'search', 'uses' => 'FormController@search']);
        /********************************************************************************************* İletişim */
    });
});
