<!DOCTYPE html>
<html lang="{{ _clang() }}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="content-language" content="tr-TR"/>
    @if (array_key_exists('metaTags', View::getSections()))
        @yield('metaTags')
    @else
        @pageTitle(_config('site_name'))
        @pageIndex('index follow')
        @pageDescription(trans('meta.title'))
        @pageImage(_asset('images/logo.png'))
    @endif
    @include('front._.meta')
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no"/>
    <link rel="stylesheet" href="{!! asset('css/app.css') !!}">
    <link rel="stylesheet" href="{!! asset('css/custom.css') !!}">
    <link rel="shortcut icon" href="{!! asset('favicon.png') !!}" type="image/x-icon"/>
</head>

<body>

<div class="porsion">
    @include("front._.header")
    @if($current_menu == "home")
        <div id="fullpage">@endif
            @yield("content")
            @include("front._.footer")
            @if($current_menu == "home")</div>
    @endif
</div>

@include("front._.cookie")
<script src="{!! asset('js/app.js') !!}"></script>
<script type="text/javascript">
    // Parallax nesnesini başlat
    var scenes = document.getElementsByClassName('scene');
    for (var i = 0; i < scenes.length; i++) {
        var parallaxInstance = new Parallax(scenes[i]);
    }
</script>
@yield('scripts')
@include('front._.status')
</body>
</html>
