@extends('main')
@setmenu('search')
@section('content')
    <div class="sub-page">
        <div class="sub-hero" style="background-image:url({{ $page->getPhoto() }});">
            <div class="wrap">
                <div class="page-title tac">{{ $page->name }}</div>
                <div class="breadcrumb">
                    <section>
                        <a href="{{ route("front.home") }}">{{ trans("breadcrumb.home") }}</a>
                        <i>/</i>
                        <strong>{{ $page->name }}</strong>
                    </section>
                </div>
            </div>
        </div>
        <div class="mask"><img src="{{ asset("images/mask-hero.png") }}" alt=""/></div>
    </div>

    <div class="w100 top-50 bottom-100">

        <div class="wrap-slim">

            <div class="search-list">
                <ul>
                    @foreach($combinedResults as $result)
                        @if(class_basename(get_class($result)) == "Product")
                            <li>
                                <a href="{{ route("front.product", ["category_slug" => $result->category->slug, "slug" => $result->slug]) }}">
                                    <div class="search-list-picture"><img
                                                src="{{ $result->getCover() }}"
                                                alt=""/></div>
                                    <div class="search-list-content">
                                        <div class="search-list-title">{{ $result->name }}</div>
                                        <div class="search-list-info">
                                            <i>{{ $result->category->name }}</i>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        @elseif(class_basename(get_class($result)) == "Category")
                            <li>
                                <a href="{{ route("front.category", ["slug" => $result->slug]) }}">
                                    <div class="search-list-picture"><img
                                                src="{{ $result->getBanner() }}"
                                                alt=""/></div>
                                    <div class="search-list-content">
                                        <div class="search-list-title">{{ $result->name }}</div>
                                        <div class="search-list-info">
                                            <i>{{ trans("search.category") }}</i>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        @elseif(class_basename(get_class($result)) == "Faq")
                            <li>
                                <a href="{{ route("front.faq") }}">
                                    <div class="search-list-content">
                                        <div class="search-list-title">{{ $result->name }}</div>
                                        <div class="search-list-info">
                                            <i>{{ trans("search.faq") }}</i>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        @elseif(class_basename(get_class($result)) == "Article")
                            @if($result->category->parent_id == 3 )
                                {{--bloglar--}}
                                <li>
                                    <a href="{{ route("front.blog", ["slug" => $result->slug]) }}">
                                        <div class="search-list-picture"><img
                                                    src="{{ $result->getPhoto() }}"
                                                    alt=""/></div>
                                        <div class="search-list-content">
                                            <div class="search-list-title">{{ $result->name }}</div>
                                            <div class="search-list-info">
                                                <i>{{ trans("search.blog") }}</i>
                                                <span>{{ $result->created_at->format("d.m.Y") }}</span>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                            @elseif($result->category->id == 4)
                                {{--haberler--}}
                                <li>
                                    <a href="{{ route("front.new", ["slug" => $result->slug]) }}">
                                        <div class="search-list-picture"><img
                                                    src="{{ $result->getPhoto() }}"
                                                    alt=""/></div>
                                        <div class="search-list-content">
                                            <div class="search-list-title">{{ $result->name }}</div>
                                            <div class="search-list-info">
                                                <i>{{ trans("search.new") }}</i>
                                                <span>{{ $result->created_at->format("d.m.Y") }}</span>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                            @elseif($result->category->id == 5)
                                {{--Etkinlikler--}}
                                <li>
                                    <a href="{{ route("front.activity", ["slug" => $result->slug]) }}">
                                        <div class="search-list-picture"><img
                                                    src="{{ $result->getPhoto() }}"
                                                    alt=""/></div>
                                        <div class="search-list-content">
                                            <div class="search-list-title">{{ $result->name }}</div>
                                            <div class="search-list-info">
                                                <i>{{ trans("search.activity") }}</i>
                                                <span>{{ $result->created_at->format("d.m.Y") }}</span>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                            @endif
                        @elseif(class_basename(get_class($result)) == "Redirect")
                            {{--Pişirme Rehberi--}}
                            <li>
                                <a href="{{ route("front.guide") }}">
                                    <div class="search-list-picture"><img
                                                src="{{ $result->getPhoto() }}"
                                                alt=""/></div>
                                    <div class="search-list-content">
                                        <div class="search-list-title">{{ $result->name }}</div>
                                        <div class="search-list-info">
                                            <i>{{ trans("search.guide") }}</i>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        @endif

                    @endforeach
                </ul>
            </div>
        </div>
    </div>
@endsection
