@extends("main")
@setmenu("all-products")
@section("content")
    <div class="w100 block-{{ $styles[$styleName] }}">
        <div class="category-page category-{{ $styles[$styleName] }}">
            <div class="wrap">
                <div class="category-hero">
                    <div class="category-hero-content">
                        <h1 class="page-title space-bottom">{{ trans("products.all_products") }}</h1>
                    </div>
                </div>
                <div class="product-list">
                    <ul>
                        @foreach($data as $product)
                            <li>
                                <a href="{{ route("front.product", ["category_slug" => $product->category->slug, "slug" => $product->slug]) }}"
                                   class="product-item">
                                    <picture><img src="{{ $product->getCover() }}" alt=""/></picture>
                                    <div class="product-item-cat"><small>{{ $product->category->name }}</small></div>
                                    <strong>{{ $product->name }}</strong>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
@endsection