@extends("main")
@setmenu("product")
@section('metaTags')
    @pageTitle(seoTitle($datum->meta,$datum->{'name_'._clang()}))
    @pageDescription(seoDescription($datum->meta,$datum->{'content_'._clang()}))
    @pageImage($datum->getCover())
@endsection
@section("content")
    <div class="w100 block-gurme {{ $datum->category->style }}">

        <div class="category-page {{ str_replace("block", "category", $datum->category->style) }} category-related">

            <div class="product-hero">

                <div class="scene">
                    <div data-depth="0.2" class="w100"><img src="{{ $datum->getMini1() }}" alt=""></div>
                    <div data-depth="0.4" class="w100"><img src="{{ $datum->getMini2() }}" alt=""></div>
                </div>

                <div class="wrap">

                    <div class="product-hero-in">
                        <div class="product-hero-picture"><img src="{{ $datum->getCover() }}" alt=""/></div>
                        <div class="product-hero-highlights">
                            <div class="vertical-out">
                                <div class="vertical-in">
                                    <ul>
                                        @foreach($datum->features as $feature)
                                            <li>
                                                <picture><img src="{{ $feature->getPhoto() }}" alt=""/></picture>
                                                <section><small>{{ $feature->name }}</small></section>
                                            </li>
                                        @endforeach

                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="page-title tac">{{ $datum->name }}</div>
                    <div class="page-text space-top tac">{!! $datum->spot !!}</div>

                </div>
            </div>

            <div class="wrap-slim">

                @if($datum->youtube_link)
                    <div class="product-video">
                        <img src="{{ asset("images/product-video.png") }}" alt=""/>
                        <iframe width="100%" height="100%"
                                src="{{ $datum->youtube_link }}"
                                title="YouTube video player" frameborder="0"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                allowfullscreen></iframe>
                    </div>
                @endif

                <div class="product-about top-50">
                    {!! $datum->content !!}
                </div>

                <div class="gallery bottom-50">
                    <div class="inner-5">
                        <ul>
                            @foreach($datum->images as $image)
                                <li><a class="fancybox" data-fancybox="porsion-gallery"
                                       href="{{ str_replace("\\", "/", $image->url()) }}">
                                        <section>
                                            <picture
                                                    style="background-image:url({{ str_replace("\\", "/", $image->url()) }});">
                                                <img
                                                        src="{{ asset("images/for-gallery.png") }}" alt=""/></picture>
                                        </section>
                                    </a></li>
                            @endforeach
                        </ul>
                    </div>
                </div>

                @if($others->count() > 0)
                    <div class="page-title tac top-100">{{ trans("products.others") }}</div>
                @endif

            </div>

            <div class="products-related bottom-150">
                <div class="products-related-mask"></div>
                <div class="slider-cat-wrap">
                    <div class="slider-cat">

                        @foreach($others as $other)
                            <div class="slider-cat-item">
                                <a href="{{ route("front.product", ["category_slug" => $other->category->slug, "slug" => $other->slug]) }}">
                                    <picture><img src="{{ $other->getCover() }}" alt=""/></picture>
                                    <section><strong>{{ $other->name }}</strong></section>
                                </a>
                            </div>
                        @endforeach

                    </div>
                </div>
            </div>

        </div>

    </div>
@endsection