@extends("main")
@setmenu("category")
@section('metaTags')
    @pageTitle(seoTitle($datum->meta,$datum->{'name_'._clang()}))
    @pageDescription(seoDescription($datum->meta,$datum->{'content_'._clang()}))
    @pageImage($datum->getBanner())
@endsection
@section("content")
    <div class="w100 {{ $datum->style }}">
        <div class="category-page {{ str_replace("block", "category", $datum->style) }}">
            <div class="wrap">
                <div class="category-hero">
                    <div class="category-hero-content">
                        <h1 class="page-title space-bottom">{{ $datum->name }}</h1>
                        <div class="page-summary narrow">{!! $datum->short_content !!}</div>
                    </div>
                    <div class="category-hero-picture"><img src="{{ $datum->getBanner() }}" alt=""/></div>
                </div>
                <div class="product-list">
                    <ul>
                        @foreach($datum->products as $product)
                            <li>
                                <a href="{{ route("front.product", ["category_slug" => $product->category->slug, "slug" => $product->slug]) }}"
                                   class="product-item">
                                    <picture><img src="{{ $product->getCover() }}" alt=""/></picture>
                                    <div class="product-item-cat"><small>{{ $datum->name }}</small></div>
                                    <strong>{{ $product->name }}</strong>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="w100 top-100 bottom-100">
        <div class="wrap">
            <div class="page-text">
                {!! $datum->content !!}
            </div>
        </div>
    </div>
@endsection