@extends("main")
@setmenu("home")
@section("content")

    {{--$sliders--}}
    @include("front.home._.sliders")

    @include("front.home._.references")

    @foreach($showroomCategories as $key => $homeCategory)
        <div class="section section-porsion {{ $homeCategory->style }}" id="section{{ $loop->iteration+1 }}">

            <div class="bg-text-wrap">
                <div class="bg-text-container">
                    <div class="animate-text">
                        <span>{{ strtoupper($homeCategory->name) }} {{ strtoupper($homeCategory->name) }} {{ strtoupper($homeCategory->name) }} {{ strtoupper($homeCategory->name) }} </span>
                    </div>
                </div>
            </div>

            <div class="scene">
                <div data-depth="0.2" class="w100">
                    <img src="{{ $homeCategory->getMini1() }}" alt="">
                </div>
                <div data-depth="0.4" class="w100">
                    <img src="{{ $homeCategory->getMini2() }}" alt="">
                </div>
            </div>

            <div class="hero-cat-wrap reveal">
                <div class="hero-cat">
                    <div class="hero-cat-content">
                        <div class="wrap">
                            <div class="page-title">{{ $homeCategory->name }}</div>
                            <div class="hero-cat-cta">
                                <div class="link-all"><a href="{{ route("front.category", ["slug" => $homeCategory->slug]) }}">{{ trans("home.discover_products") }}</a></div>
                            </div>
                        </div>
                    </div>
                    <div class="hero-cat-gallery">

                        <div class="slider-cat-wrap">
                            <div class="slider-cat">

                                @foreach($homeCategory->products as $product)
                                    <div class="slider-cat-item">
                                        <a href="{{ route("front.product", ["category_slug" => $homeCategory->slug, "slug" => $product->slug]) }}">
                                            <picture><img src="{{ $product->getCover() }}" alt=""/></picture>
                                            <section><strong>{{ $product->name }}</strong></section>
                                        </a>
                                    </div>
                                @endforeach

                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    @endforeach

    <div class="section section-porsion" id="section6">

        <div class="bg-text-wrap bg-text-bottom">
            <div class="bg-text-container">
                <div class="animate-text">
                    <span>{!! trans("home.ribbon_tape") !!}</span>
                </div>
            </div>
        </div>

        <div class="hero-vh100">
            <div class="wrap">
                <div class="hero-news top-50">

                    <div class="w100">
                        <div class="page-title space-bottom text-orange wa">{{ trans("home.pews") }}</div>
                        <div class="hero-cat-cta hide-mobile">
                            <div class="link-all"><a href="{{ route("front.news") }}">{{ trans("home.all_news") }}</a></div>
                        </div>
                    </div>

                    <div class="news-list reveal">
                        <ul>
                            @foreach($showroomBlogs as $showBlog)
                                <li>
                                    <a href="{{ route("front.new", ["slug" => $showBlog->slug]) }}" class="news-item">
                                        <time>{{ $showBlog->created_at->format("d.m.Y") }}</time>
                                        <picture><i><img src="{{ $showBlog->getPhoto() }}" alt=""/></i></picture>
                                        <strong>{{ $showBlog->name }}</strong>
                                        <span>{{ trans("home.read_more") }}</span>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>

                </div>
            </div>
        </div>

    </div>

    <div class="section section-porsion" id="section7">

        <div class="hero-vh100 reveal">
            <div class="vertical-out">
                <div class="vertical-in">
                    <div class="wrap">

                        <div class="advantages-wrap reveal">
                            <picture><img src="{{ $pages["widgets"]->getPhoto() }}" alt="" class="w100"/></picture>
                            <div class="porsion-advantages">
                                <ul>
                                    @foreach($widgets as $widget)
                                        <li>
                                            <div class="advantage-item">
                                                <section>
                                                    <picture><img src="{{ $widget->getPhoto() }}" alt=""/>
                                                    </picture>
                                                    <strong>{{ $widget->name }}</strong>
                                                </section>
                                                <small>{!! $widget->content !!}</small>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection