@extends("main")
@setmenu("guide")
@section('metaTags')
    @pageTitle(seoTitle($page->meta,$page->{'name_'._clang()}))
    @pageDescription(seoDescription($page->meta,$page->{'content_'._clang()}))
    @pageImage($page->getPhoto())
@endsection
@section("content")
    <div class="sub-page">
        <div class="sub-hero" style="background-image:url({{ $page->getPhoto() }});">
            <div class="wrap">
                <div class="page-title tac">{{ $page->name }}</div>
                <div class="breadcrumb">
                    <section>
                        <a href="{{ route("front.home") }}">{{ trans("breadcrumb.home") }}</a>
                        <i>/</i>
                        <strong>{{ $page->name }}</strong>
                    </section>
                </div>
            </div>
        </div>
        <div class="mask"><img src="{{ asset("images/mask-hero.png") }}" alt=""/></div>
    </div>
    <div class="w100 top-50 bottom-100">
        <div class="wrap-slim">
            <div class="page-title text-orange bottom-100">{{ $page->spot }}</div>
            @foreach($dataTexts as $text)
                <div class="block-flexed bottom-100 reveal">
                    <div class="flex-left">
                        <div class="medium-title">{{ $text->name }}</div>
                    </div>
                    <div class="flex-right">
                        <div class="page-text">{!! $text->content !!}</div>
                    </div>
                </div>
            @endforeach
            <div class="video-list reveal">
                <div class="inner-20">
                    <ul>
                        @foreach($dataVideos as $video)
                            <li>
                                <a data-fancybox="" href="{{ $video->link }}">
                                    <picture><img
                                                src="{{ $video->getPhoto() }}"
                                                alt=""/></picture>
                                    <section>
                                        <strong>{{ $video->name }}</strong>
                                        <i>{{ $video->video_time }}</i>
                                    </section>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
@endsection