@extends("main")
@setmenu("faq")
@section('metaTags')
    @pageTitle(seoTitle($page->meta,$page->{'name_'._clang()}))
    @pageDescription(seoDescription($page->meta,$page->{'content_'._clang()}))
    @pageImage($page->getPhoto())
@endsection
@section("content")
    <div class="sub-page">
        <div class="sub-hero" style="background-image:url({{ $page->getPhoto() }});">
            <div class="wrap">
                <div class="page-title tac">{{ $page->name }}</div>
                <div class="breadcrumb">
                    <section>
                        <a href="{{ route("front.home") }}">{{ trans("breadcrumb.home") }}</a>
                        <i>/</i>
                        <strong>{{ $page->spot }}</strong>
                    </section>
                </div>
            </div>
        </div>
        <div class="mask"><img src="{{ asset("images/mask-hero.png") }}" alt=""/></div>
    </div>

    <div class="w100 top-100 bottom-100 block-faq">

        <div class="wrap">

            @foreach($data as $datum)
                <div class="block-wrap" data-sticky-container>
                    <div class="block-narrow sticky" data-margin-top="120" data-sticky-for="1023"
                         data-sticky-class="is-sticky">
                        <div class="medium-title text-orange">{{ $datum->name }}</div>
                    </div>
                    <div class="block-wide">
                        <div class="accordion">

                            <div class="accordion-section">

                                @foreach($datum->faqs as $key => $faq)
                                    <a class="accordion-section-title"
                                       href="#accordion-{{ $key+1 }}">{!! $faq->name !!}</a>
                                    <div id="accordion-{{ $key+1 }}" class="accordion-section-content">
                                        <div class="accordion-section-text">{!! $faq->content !!}</div>
                                    </div>
                                @endforeach

                            </div>

                        </div>
                    </div>
                </div>
            @endforeach

        </div>

    </div>
@endsection